/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.LocaleFinder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLNationalVarchar;
import org.apache.derby.iapi.types.StringDataValue;

public class SQLNationalChar
extends SQLChar {
    public String getTypeName() {
        return "NATIONAL CHAR";
    }

    public int getTypeFormatId() {
        return 363;
    }

    public DataValueDescriptor getClone() {
        try {
            return new SQLNationalChar(this.getString(), this.getLocaleFinder());
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT("Unexpected exception", se);
            return null;
        }
    }

    public DataValueDescriptor getNewNull() {
        SQLNationalChar result = new SQLNationalChar();
        result.setLocaleFinder(this.getLocaleFinder());
        return result;
    }

    public SQLNationalChar() {
    }

    public SQLNationalChar(String val, LocaleFinder localeFinder) {
        super(val);
        this.setLocaleFinder(localeFinder);
    }

    public Date getDate(Calendar cal) throws StandardException {
        return this.nationalGetDate(cal);
    }

    public Time getTime(Calendar cal) throws StandardException {
        return this.nationalGetTime(cal);
    }

    public Timestamp getTimestamp(Calendar cal) throws StandardException {
        return this.nationalGetTimestamp(cal);
    }

    public void setValue(Date theValue, Calendar cal) throws StandardException {
        this.setValue(this.getDateFormat(cal).format(theValue));
    }

    public void setValue(Time theValue, Calendar cal) throws StandardException {
        this.setValue(this.getTimeFormat(cal).format(theValue));
    }

    public void setValue(Timestamp theValue, Calendar cal) throws StandardException {
        this.setValue(this.getTimestampFormat(cal).format(theValue));
    }

    public int typePrecedence() {
        return 16;
    }

    protected int stringCompare(SQLChar char1, SQLChar char2) throws StandardException {
        return char1.stringCollatorCompare(char2);
    }

    protected StringDataValue getNewVarchar() throws StandardException {
        SQLNationalVarchar result = new SQLNationalVarchar();
        result.setLocaleFinder(this.getLocaleFinder());
        return result;
    }

    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor source) throws StandardException {
        this.normalize(desiredType, ((DataType)source).getNationalString(this.getLocaleFinder()));
    }

    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        this.setValue(((DataType)theValue).getNationalString(this.getLocaleFinder()));
    }

    protected boolean isNationalString() {
        return true;
    }

    public int hashCode() {
        return this.nationalHashCode();
    }
}

