/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.RuleBasedCollator;
import java.util.Calendar;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.CollatorSQLClob;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.ReaderToUTF8Stream;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.StringDataValue;

public class SQLClob
extends SQLVarchar {
    public String getTypeName() {
        return "CLOB";
    }

    public DataValueDescriptor getClone() {
        try {
            return new SQLClob(this.getString());
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT("Unexpected exception", se);
            return null;
        }
    }

    public DataValueDescriptor getNewNull() {
        return new SQLClob();
    }

    public StringDataValue getValue(RuleBasedCollator collatorForComparison) {
        if (collatorForComparison == null) {
            return this;
        }
        CollatorSQLClob s = new CollatorSQLClob(collatorForComparison);
        s.copyState(this);
        return s;
    }

    public int getTypeFormatId() {
        return 447;
    }

    public SQLClob() {
    }

    public SQLClob(String val) {
        super(val);
    }

    public int typePrecedence() {
        return 14;
    }

    public Object getObject() throws StandardException {
        throw this.dataTypeConversion("java.lang.Object");
    }

    public boolean getBoolean() throws StandardException {
        throw this.dataTypeConversion("boolean");
    }

    public byte getByte() throws StandardException {
        throw this.dataTypeConversion("byte");
    }

    public short getShort() throws StandardException {
        throw this.dataTypeConversion("short");
    }

    public int getInt() throws StandardException {
        throw this.dataTypeConversion("int");
    }

    public long getLong() throws StandardException {
        throw this.dataTypeConversion("long");
    }

    public float getFloat() throws StandardException {
        throw this.dataTypeConversion("float");
    }

    public double getDouble() throws StandardException {
        throw this.dataTypeConversion("double");
    }

    public int typeToBigDecimal() throws StandardException {
        throw this.dataTypeConversion("java.math.BigDecimal");
    }

    public byte[] getBytes() throws StandardException {
        throw this.dataTypeConversion("byte[]");
    }

    public Date getDate(Calendar cal) throws StandardException {
        throw this.dataTypeConversion("java.sql.Date");
    }

    public Time getTime(Calendar cal) throws StandardException {
        throw this.dataTypeConversion("java.sql.Time");
    }

    public Timestamp getTimestamp(Calendar cal) throws StandardException {
        throw this.dataTypeConversion("java.sql.Timestamp");
    }

    public final String getTraceString() throws StandardException {
        if (this.isNull()) {
            return "NULL";
        }
        if (this.getStream() != null) {
            return this.getTypeName() + "(" + this.getStream().toString() + ")";
        }
        return this.getTypeName() + "(" + this.getLength() + ")";
    }

    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor sourceValue) throws StandardException {
        if (sourceValue instanceof SQLClob) {
            SQLClob clob = (SQLClob)sourceValue;
            if (clob.stream != null) {
                this.copyState(clob);
                return;
            }
        }
        super.normalize(desiredType, sourceValue);
    }

    public void setValue(Time theValue, Calendar cal) throws StandardException {
        this.throwLangSetMismatch("java.sql.Time");
    }

    public void setValue(Timestamp theValue, Calendar cal) throws StandardException {
        this.throwLangSetMismatch("java.sql.Timestamp");
    }

    public void setValue(Date theValue, Calendar cal) throws StandardException {
        this.throwLangSetMismatch("java.sql.Date");
    }

    public void setBigDecimal(Number bigDecimal) throws StandardException {
        this.throwLangSetMismatch("java.math.BigDecimal");
    }

    public void setValue(int theValue) throws StandardException {
        this.throwLangSetMismatch("int");
    }

    public void setValue(double theValue) throws StandardException {
        this.throwLangSetMismatch("double");
    }

    public void setValue(float theValue) throws StandardException {
        this.throwLangSetMismatch("float");
    }

    public void setValue(short theValue) throws StandardException {
        this.throwLangSetMismatch("short");
    }

    public void setValue(long theValue) throws StandardException {
        this.throwLangSetMismatch("long");
    }

    public void setValue(byte theValue) throws StandardException {
        this.throwLangSetMismatch("byte");
    }

    public void setValue(boolean theValue) throws StandardException {
        this.throwLangSetMismatch("boolean");
    }

    public void setValue(byte[] theValue) throws StandardException {
        this.throwLangSetMismatch("byte[]");
    }

    final void setObject(Object theValue) throws StandardException {
        Clob vc = (Clob)theValue;
        try {
            long vcl = vc.length();
            if (vcl < 0L || vcl > Integer.MAX_VALUE) {
                throw this.outOfRange();
            }
            this.setValue(new ReaderToUTF8Stream(vc.getCharacterStream(), (int)vcl, 0, "CLOB"), (int)vcl);
        }
        catch (SQLException e) {
            throw this.dataTypeConversion("DAN-438-tmp");
        }
    }
}

