/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UTFDataFormatException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.CollationElementIterator;
import java.text.CollationKey;
import java.text.DateFormat;
import java.text.RuleBasedCollator;
import java.util.Calendar;
import java.util.Locale;
import org.apache.derby.iapi.db.DatabaseContext;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.LocaleFinder;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.FormatIdInputStream;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.CollatorSQLChar;
import org.apache.derby.iapi.types.ConcatableDataValue;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.Like;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLDate;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLTime;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.util.StringUtil;

public class SQLChar
extends DataType
implements StringDataValue,
StreamStorable {
    protected static final int RETURN_SPACE_THRESHOLD = 4096;
    private static final int GROWBY_FOR_CHAR = 64;
    private static final char[] BLANKS = new char[40];
    char[][] arg_passer = new char[1][];
    private String value;
    private char[] rawData;
    private int rawLength = -1;
    private CollationKey cKey;
    InputStream stream;
    private int[] intArray;
    private int intLength;
    private LocaleFinder localeFinder;
    private static final int BASE_MEMORY_USAGE;

    private static void appendBlanks(char[] ca, int offset, int howMany) {
        while (howMany > 0) {
            int count = howMany > BLANKS.length ? BLANKS.length : howMany;
            System.arraycopy(BLANKS, 0, ca, offset, count);
            howMany -= count;
            offset += count;
        }
    }

    public boolean getBoolean() throws StandardException {
        if (this.isNull()) {
            return false;
        }
        String cleanedValue = this.getString().trim();
        return !cleanedValue.equals("0") && !cleanedValue.equals("false");
    }

    public byte getByte() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            return Byte.parseByte(this.getString().trim());
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("22018", "byte");
        }
    }

    public short getShort() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            return Short.parseShort(this.getString().trim());
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("22018", "short");
        }
    }

    public int getInt() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            return Integer.parseInt(this.getString().trim());
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("22018", "int");
        }
    }

    public long getLong() throws StandardException {
        if (this.isNull()) {
            return 0L;
        }
        try {
            return Long.parseLong(this.getString().trim());
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("22018", "long");
        }
    }

    public float getFloat() throws StandardException {
        if (this.isNull()) {
            return 0.0f;
        }
        try {
            return new Float(this.getString().trim()).floatValue();
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("22018", "float");
        }
    }

    public double getDouble() throws StandardException {
        if (this.isNull()) {
            return 0.0;
        }
        try {
            return new Double(this.getString().trim());
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("22018", "double");
        }
    }

    public int typeToBigDecimal() throws StandardException {
        return 1;
    }

    public Date getDate(Calendar cal) throws StandardException {
        return SQLChar.getDate(cal, this.getString(), this.getLocaleFinder());
    }

    public static Date getDate(Calendar cal, String str, LocaleFinder localeFinder) throws StandardException {
        if (str == null) {
            return null;
        }
        SQLDate internalDate = new SQLDate(str, false, localeFinder);
        return internalDate.getDate(cal);
    }

    public Time getTime(Calendar cal) throws StandardException {
        return SQLChar.getTime(cal, this.getString(), this.getLocaleFinder());
    }

    public static Time getTime(Calendar cal, String str, LocaleFinder localeFinder) throws StandardException {
        if (str == null) {
            return null;
        }
        SQLTime internalTime = new SQLTime(str, false, localeFinder, cal);
        return internalTime.getTime(cal);
    }

    public Timestamp getTimestamp(Calendar cal) throws StandardException {
        return SQLChar.getTimestamp(cal, this.getString(), this.getLocaleFinder());
    }

    public static Timestamp getTimestamp(Calendar cal, String str, LocaleFinder localeFinder) throws StandardException {
        if (str == null) {
            return null;
        }
        SQLTimestamp internalTimestamp = new SQLTimestamp(str, false, localeFinder, cal);
        return internalTimestamp.getTimestamp(cal);
    }

    public Object getObject() throws StandardException {
        return this.getString();
    }

    public InputStream getStream() throws StandardException {
        return this.stream;
    }

    public int getLength() throws StandardException {
        if (this.rawLength != -1) {
            return this.rawLength;
        }
        String tmpString = this.getString();
        return tmpString == null ? 0 : tmpString.length();
    }

    public String getTypeName() {
        return "CHAR";
    }

    public String getString() throws StandardException {
        if (this.value == null) {
            int len = this.rawLength;
            if (len != -1) {
                this.value = new String(this.rawData, 0, len);
                if (len > 4096) {
                    this.rawData = null;
                    this.rawLength = -1;
                    this.intArray = null;
                    this.intLength = 0;
                    this.cKey = null;
                }
            } else if (this.stream != null) {
                try {
                    if (this.stream instanceof FormatIdInputStream) {
                        this.readExternal((FormatIdInputStream)this.stream);
                    } else {
                        this.readExternal(new FormatIdInputStream(this.stream));
                    }
                    this.stream = null;
                    return this.getString();
                }
                catch (IOException ioe) {
                    throw StandardException.newException("XCL30.S", ioe, (Object)"java.sql.String");
                }
            }
        }
        return this.value;
    }

    public char[] getCharArray() throws StandardException {
        if (this.isNull()) {
            return null;
        }
        if (this.rawLength != -1) {
            return this.rawData;
        }
        this.getString();
        this.rawData = this.value.toCharArray();
        this.rawLength = this.rawData.length;
        this.intArray = null;
        this.intLength = 0;
        this.cKey = null;
        return this.rawData;
    }

    public InputStream returnStream() {
        return this.stream;
    }

    public final void setStream(InputStream newStream) {
        this.value = null;
        this.rawLength = -1;
        this.stream = newStream;
        this.intArray = null;
        this.intLength = 0;
        this.cKey = null;
    }

    public void loadStream() throws StandardException {
        this.getString();
    }

    public int getTypeFormatId() {
        return 78;
    }

    public boolean isNull() {
        return this.value == null && this.rawLength == -1 && this.stream == null;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        boolean isRaw;
        SanityManager.ASSERT(!this.isNull());
        String lvalue = null;
        char[] data = null;
        int strlen = this.rawLength;
        if (strlen < 0) {
            lvalue = this.value;
            strlen = lvalue.length();
            isRaw = false;
        } else {
            data = this.rawData;
            isRaw = true;
        }
        int utflen = strlen;
        for (int i = 0; i < strlen && utflen <= 65535; ++i) {
            char c;
            char c2 = c = isRaw ? data[i] : lvalue.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') continue;
            if (c > '\u07ff') {
                utflen += 2;
                continue;
            }
            ++utflen;
        }
        boolean isLongUTF = false;
        if (utflen > 65535) {
            isLongUTF = true;
            utflen = 0;
        }
        out.write(utflen >>> 8 & 0xFF);
        out.write(utflen >>> 0 & 0xFF);
        for (int i = 0; i < strlen; ++i) {
            char c;
            char c3 = c = isRaw ? data[i] : lvalue.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                out.write(c);
                continue;
            }
            if (c > '\u07ff') {
                out.write(0xE0 | c >> 12 & 0xF);
                out.write(0x80 | c >> 6 & 0x3F);
                out.write(0x80 | c >> 0 & 0x3F);
                continue;
            }
            out.write(0xC0 | c >> 6 & 0x1F);
            out.write(0x80 | c >> 0 & 0x3F);
        }
        if (isLongUTF) {
            out.write(224);
            out.write(0);
            out.write(0);
        }
    }

    public void readExternalFromArray(ArrayInputStream in) throws IOException {
        this.arg_passer[0] = this.rawData;
        this.rawLength = in.readDerbyUTF(this.arg_passer);
        this.rawData = this.arg_passer[0];
        this.value = null;
        this.stream = null;
        this.intArray = null;
        this.intLength = 0;
        this.cKey = null;
    }

    public void readExternal(ObjectInput in) throws IOException {
        int requiredLength;
        int utflen = in.readUnsignedShort();
        int minGrowBy = this.growBy();
        if (utflen != 0) {
            requiredLength = utflen;
        } else {
            requiredLength = in.available();
            if (requiredLength < minGrowBy) {
                requiredLength = minGrowBy;
            }
        }
        char[] str = this.rawData == null || requiredLength > this.rawData.length ? new char[requiredLength] : this.rawData;
        int arrayLength = str.length;
        this.rawData = null;
        this.restoreToNull();
        int count = 0;
        int strlen = 0;
        while (count < utflen || utflen == 0) {
            int char2;
            char actualChar;
            int c;
            try {
                c = in.readUnsignedByte();
            }
            catch (EOFException eof) {
                if (utflen == 0) break;
                throw new EOFException();
            }
            if (strlen >= arrayLength) {
                int growby = in.available();
                if (growby < minGrowBy) {
                    growby = minGrowBy;
                }
                int newstrlength = arrayLength + growby;
                char[] oldstr = str;
                str = new char[newstrlength];
                System.arraycopy(oldstr, 0, str, 0, arrayLength);
                arrayLength = newstrlength;
            }
            if ((c & 0x80) == 0) {
                ++count;
                actualChar = (char)c;
            } else if ((c & 0x60) == 64) {
                if (utflen != 0 && (count += 2) > utflen) {
                    throw new UTFDataFormatException();
                }
                char2 = in.readUnsignedByte();
                if ((char2 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                actualChar = (char)((c & 0x1F) << 6 | char2 & 0x3F);
            } else if ((c & 0x70) == 96) {
                if (utflen != 0 && (count += 3) > utflen) {
                    throw new UTFDataFormatException();
                }
                char2 = in.readUnsignedByte();
                int char3 = in.readUnsignedByte();
                if (c == 224 && char2 == 0 && char3 == 0 && utflen == 0) break;
                if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                actualChar = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
            } else {
                throw new UTFDataFormatException();
            }
            str[strlen++] = actualChar;
        }
        this.rawData = str;
        this.rawLength = strlen;
        this.intArray = null;
        this.intLength = 0;
        this.cKey = null;
    }

    protected int growBy() {
        return 64;
    }

    public void restoreToNull() {
        this.value = null;
        this.stream = null;
        this.rawLength = -1;
        this.intArray = null;
        this.intLength = 0;
        this.cKey = null;
    }

    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) throws StandardException {
        if (!orderedNulls && (this.isNull() || other.isNull())) {
            return unknownRV;
        }
        if (!(other instanceof SQLChar)) {
            return other.compare(SQLChar.flip(op), this, orderedNulls, unknownRV);
        }
        return super.compare(op, other, orderedNulls, unknownRV);
    }

    public int compare(DataValueDescriptor other) throws StandardException {
        if (this.typePrecedence() < other.typePrecedence()) {
            return -other.compare(this);
        }
        return this.stringCompare(this, (SQLChar)other);
    }

    public Object cloneObject() {
        if (this.stream == null) {
            return this.getClone();
        }
        SQLChar self = (SQLChar)this.getNewNull();
        self.copyState(this);
        return self;
    }

    public DataValueDescriptor getClone() {
        try {
            return new SQLChar(this.getString());
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT("Unexpected exception", se);
            return null;
        }
    }

    public DataValueDescriptor getNewNull() {
        return new SQLChar();
    }

    public StringDataValue getValue(RuleBasedCollator collatorForComparison) {
        if (collatorForComparison == null) {
            return this;
        }
        CollatorSQLChar s = new CollatorSQLChar(collatorForComparison);
        s.copyState(this);
        return s;
    }

    public final void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException {
        this.setValue(resultSet.getString(colNumber));
    }

    public final void setInto(PreparedStatement ps, int position) throws SQLException, StandardException {
        ps.setString(position, this.getString());
    }

    public SQLChar() {
    }

    public SQLChar(String val) {
        this.value = val;
    }

    public void setValue(String theValue) {
        this.stream = null;
        this.rawLength = -1;
        this.intArray = null;
        this.intLength = 0;
        this.cKey = null;
        this.value = theValue;
    }

    public void setValue(boolean theValue) throws StandardException {
        this.setValue(theValue ? "1" : "0");
    }

    public void setValue(int theValue) throws StandardException {
        this.setValue(Integer.toString(theValue));
    }

    public void setValue(double theValue) throws StandardException {
        this.setValue(Double.toString(theValue));
    }

    public void setValue(float theValue) throws StandardException {
        this.setValue(Float.toString(theValue));
    }

    public void setValue(short theValue) throws StandardException {
        this.setValue(Short.toString(theValue));
    }

    public void setValue(long theValue) throws StandardException {
        this.setValue(Long.toString(theValue));
    }

    public void setValue(byte theValue) throws StandardException {
        this.setValue(Byte.toString(theValue));
    }

    public void setValue(byte[] theValue) throws StandardException {
        if (theValue == null) {
            this.restoreToNull();
            return;
        }
        int mod = theValue.length % 2;
        int len = theValue.length / 2 + mod;
        char[] carray = new char[len];
        int cindex = 0;
        int bindex = 0;
        if (mod == 1) {
            carray[--len] = (char)(theValue[theValue.length - 1] << 8);
        }
        while (cindex < len) {
            carray[cindex] = (char)(theValue[bindex] << 8 | theValue[bindex + 1] & 0xFF);
            bindex += 2;
            ++cindex;
        }
        this.setValue(new String(carray));
    }

    public void setBigDecimal(Number bigDecimal) throws StandardException {
        if (bigDecimal == null) {
            this.setToNull();
        } else {
            this.setValue(bigDecimal.toString());
        }
    }

    public void setValue(Date theValue, Calendar cal) throws StandardException {
        String strValue = null;
        if (theValue != null) {
            if (cal == null) {
                strValue = theValue.toString();
            } else {
                cal.setTime(theValue);
                StringBuffer sb = new StringBuffer();
                this.formatJDBCDate(cal, sb);
                strValue = sb.toString();
            }
        }
        this.setValue(strValue);
    }

    public void setValue(Time theValue, Calendar cal) throws StandardException {
        String strValue = null;
        if (theValue != null) {
            if (cal == null) {
                strValue = theValue.toString();
            } else {
                cal.setTime(theValue);
                StringBuffer sb = new StringBuffer();
                this.formatJDBCTime(cal, sb);
                strValue = sb.toString();
            }
        }
        this.setValue(strValue);
    }

    public void setValue(Timestamp theValue, Calendar cal) throws StandardException {
        String strValue = null;
        if (theValue != null) {
            if (cal == null) {
                strValue = theValue.toString();
            } else {
                cal.setTime(theValue);
                StringBuffer sb = new StringBuffer();
                this.formatJDBCDate(cal, sb);
                sb.append(' ');
                this.formatJDBCTime(cal, sb);
                int micros = (theValue.getNanos() + 500) / 1000;
                if (micros > 0) {
                    sb.append('.');
                    String microsStr = Integer.toString(micros);
                    if (microsStr.length() > 6) {
                        sb.append(microsStr.substring(0, 6));
                    } else {
                        for (int i = microsStr.length(); i < 6; ++i) {
                            sb.append('0');
                        }
                        sb.append(microsStr);
                    }
                }
                strValue = sb.toString();
            }
        }
        this.setValue(strValue);
    }

    private void formatJDBCDate(Calendar cal, StringBuffer sb) {
        SQLDate.dateToString(cal.get(1), cal.get(2) - 0 + 1, cal.get(5), sb);
    }

    private void formatJDBCTime(Calendar cal, StringBuffer sb) {
        SQLTime.timeToString(cal.get(10), cal.get(12), cal.get(13), sb);
    }

    public final void setValue(InputStream theStream, int valueLength) {
        this.setStream(theStream);
    }

    public void setObjectForCast(Object theValue, boolean instanceOfResultType, String resultTypeClassName) throws StandardException {
        if (theValue == null) {
            this.setToNull();
            return;
        }
        if ("java.lang.String".equals(resultTypeClassName)) {
            this.setValue(theValue.toString());
        } else {
            super.setObjectForCast(theValue, instanceOfResultType, resultTypeClassName);
        }
    }

    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        this.setValue(theValue.getString());
    }

    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor source) throws StandardException {
        this.normalize(desiredType, source.getString());
    }

    protected void normalize(DataTypeDescriptor desiredType, String sourceValue) throws StandardException {
        int desiredWidth = desiredType.getMaximumWidth();
        int sourceWidth = sourceValue.length();
        if (sourceWidth == desiredWidth) {
            this.setValue(sourceValue);
            return;
        }
        if (sourceWidth < desiredWidth) {
            char[] ca;
            this.setToNull();
            if (this.rawData == null || desiredWidth > this.rawData.length) {
                this.rawData = new char[desiredWidth];
                ca = this.rawData;
            } else {
                ca = this.rawData;
            }
            sourceValue.getChars(0, sourceWidth, ca, 0);
            SQLChar.appendBlanks(ca, sourceWidth, desiredWidth - sourceWidth);
            this.rawLength = desiredWidth;
            return;
        }
        this.hasNonBlankChars(sourceValue, desiredWidth, sourceWidth);
        String truncatedString = sourceValue.substring(0, desiredWidth);
        this.setValue(truncatedString);
    }

    protected final void hasNonBlankChars(String source, int start, int end) throws StandardException {
        for (int posn = start; posn < end; ++posn) {
            if (source.charAt(posn) == ' ') continue;
            throw StandardException.newException("22001", (Object)this.getTypeName(), (Object)StringUtil.formatForPrint(source), (Object)String.valueOf(start));
        }
    }

    public void setWidth(int desiredWidth, int desiredScale, boolean errorOnTrunc) throws StandardException {
        if (this.getString() == null) {
            return;
        }
        int sourceWidth = this.getLength();
        if (sourceWidth < desiredWidth) {
            if (!(this instanceof SQLVarchar)) {
                StringBuffer strbuf = new StringBuffer(this.getString());
                while (sourceWidth < desiredWidth) {
                    strbuf.append(' ');
                    ++sourceWidth;
                }
                this.setValue(new String(strbuf));
            }
        } else if (sourceWidth > desiredWidth && desiredWidth > 0) {
            if (errorOnTrunc) {
                this.hasNonBlankChars(this.getString(), desiredWidth, sourceWidth);
            }
            this.setValue(this.getString().substring(0, desiredWidth));
        }
    }

    public BooleanDataValue equals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean comparison = left instanceof SQLChar && right instanceof SQLChar ? this.stringCompare((SQLChar)left, (SQLChar)right) == 0 : SQLChar.stringCompare(left.getString(), right.getString()) == 0;
        return SQLBoolean.truthValue(left, right, comparison);
    }

    public BooleanDataValue notEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean comparison = left instanceof SQLChar && right instanceof SQLChar ? this.stringCompare((SQLChar)left, (SQLChar)right) != 0 : SQLChar.stringCompare(left.getString(), right.getString()) != 0;
        return SQLBoolean.truthValue(left, right, comparison);
    }

    public BooleanDataValue lessThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean comparison = left instanceof SQLChar && right instanceof SQLChar ? this.stringCompare((SQLChar)left, (SQLChar)right) < 0 : SQLChar.stringCompare(left.getString(), right.getString()) < 0;
        return SQLBoolean.truthValue(left, right, comparison);
    }

    public BooleanDataValue greaterThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean comparison = left instanceof SQLChar && right instanceof SQLChar ? this.stringCompare((SQLChar)left, (SQLChar)right) > 0 : SQLChar.stringCompare(left.getString(), right.getString()) > 0;
        return SQLBoolean.truthValue(left, right, comparison);
    }

    public BooleanDataValue lessOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean comparison = left instanceof SQLChar && right instanceof SQLChar ? this.stringCompare((SQLChar)left, (SQLChar)right) <= 0 : SQLChar.stringCompare(left.getString(), right.getString()) <= 0;
        return SQLBoolean.truthValue(left, right, comparison);
    }

    public BooleanDataValue greaterOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean comparison = left instanceof SQLChar && right instanceof SQLChar ? this.stringCompare((SQLChar)left, (SQLChar)right) >= 0 : SQLChar.stringCompare(left.getString(), right.getString()) >= 0;
        return SQLBoolean.truthValue(left, right, comparison);
    }

    public NumberDataValue charLength(NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLInteger();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        result.setValue(this.getLength());
        return result;
    }

    public StringDataValue concatenate(StringDataValue leftOperand, StringDataValue rightOperand, StringDataValue result) throws StandardException {
        if (leftOperand.isNull() || leftOperand.getString() == null || rightOperand.isNull() || rightOperand.getString() == null) {
            result.setToNull();
            return result;
        }
        result.setValue(leftOperand.getString().concat(rightOperand.getString()));
        return result;
    }

    public BooleanDataValue like(DataValueDescriptor pattern) throws StandardException {
        Boolean likeResult;
        if (!this.isNationalString()) {
            char[] evalCharArray = this.getCharArray();
            char[] patternCharArray = ((SQLChar)pattern).getCharArray();
            likeResult = Like.like(evalCharArray, this.getLength(), patternCharArray, pattern.getLength(), null);
        } else {
            SQLChar patternSQLChar = (SQLChar)pattern;
            likeResult = Like.like(this.getIntArray(), this.getIntLength(), patternSQLChar.getIntArray(), patternSQLChar.getIntLength(), this.getLocaleFinder().getCollator());
        }
        return SQLBoolean.truthValue((DataValueDescriptor)this, pattern, likeResult);
    }

    public BooleanDataValue like(DataValueDescriptor pattern, DataValueDescriptor escape) throws StandardException {
        Boolean likeResult;
        SanityManager.ASSERT(pattern instanceof StringDataValue && escape instanceof StringDataValue, "All three operands must be instances of StringDataValue");
        if (escape.isNull()) {
            throw StandardException.newException("22501");
        }
        if (!this.isNationalString()) {
            char[] evalCharArray = this.getCharArray();
            char[] patternCharArray = ((SQLChar)pattern).getCharArray();
            char[] escapeCharArray = ((SQLChar)escape).getCharArray();
            int escapeLength = escape.getLength();
            if (escapeCharArray != null && escapeLength != 1) {
                throw StandardException.newException("22019", new String(escapeCharArray));
            }
            SQLChar escapeSQLChar = (SQLChar)escape;
            int[] escapeIntArray = escapeSQLChar.getIntArray();
            if (escapeIntArray != null && escapeIntArray.length != 1) {
                throw StandardException.newException("22019", new String(escapeSQLChar.getCharArray()));
            }
            likeResult = Like.like(evalCharArray, this.getLength(), patternCharArray, pattern.getLength(), escapeCharArray, escapeLength, null);
        } else {
            SQLChar patternSQLChar = (SQLChar)pattern;
            SQLChar escapeSQLChar = (SQLChar)escape;
            int[] escapeIntArray = escapeSQLChar.getIntArray();
            int escapeLength = escapeSQLChar.getIntLength();
            if (escapeIntArray != null && escapeIntArray.length != 1) {
                throw StandardException.newException("22019", new String(escapeSQLChar.getCharArray()));
            }
            likeResult = Like.like(this.getIntArray(), this.getIntLength(), patternSQLChar.getIntArray(), patternSQLChar.getIntLength(), escapeIntArray, escapeLength, this.getLocaleFinder().getCollator());
        }
        return SQLBoolean.truthValue((DataValueDescriptor)this, pattern, likeResult);
    }

    public NumberDataValue locate(StringDataValue searchFrom, NumberDataValue start, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLInteger();
        }
        int startVal = start.isNull() ? 1 : start.getInt();
        if (this.isNull() || searchFrom.isNull()) {
            result.setToNull();
            return result;
        }
        String mySearchFrom = searchFrom.getString();
        String mySearchFor = this.getString();
        if (startVal < 1) {
            throw StandardException.newException("22014", (Object)new String(this.getString()), (Object)new String(mySearchFrom), (Object)new Integer(startVal));
        }
        if (mySearchFor.length() == 0) {
            result.setValue(startVal);
            return result;
        }
        result.setValue(mySearchFrom.indexOf(mySearchFor, startVal - 1) + 1);
        return result;
    }

    public ConcatableDataValue substring(NumberDataValue start, NumberDataValue length, ConcatableDataValue result, int maxLen) throws StandardException {
        if (result == null) {
            result = this.getNewVarchar();
        }
        StringDataValue stringResult = (StringDataValue)result;
        if (this.isNull() || start.isNull() || length != null && length.isNull()) {
            stringResult.setToNull();
            return stringResult;
        }
        int startInt = start.getInt();
        int lengthInt = length != null ? length.getInt() : maxLen - startInt + 1;
        if (startInt <= 0 || lengthInt < 0 || startInt > maxLen || lengthInt > maxLen - startInt + 1) {
            throw StandardException.newException("22011");
        }
        if (lengthInt < 0) {
            stringResult.setToNull();
            return stringResult;
        }
        if (startInt < 0) {
            if (startInt + this.getLength() < 0 && startInt + this.getLength() + lengthInt <= 0) {
                stringResult.setValue("");
                return stringResult;
            }
            startInt += this.getLength();
            while (startInt < 0) {
                ++startInt;
                --lengthInt;
            }
        } else if (startInt > 0) {
            --startInt;
        }
        if (lengthInt == 0 || lengthInt <= 0 - startInt || startInt > this.getLength()) {
            stringResult.setValue("");
            return stringResult;
        }
        if (lengthInt >= this.getLength() - startInt) {
            stringResult.setValue(this.getString().substring(startInt));
        } else {
            stringResult.setValue(this.getString().substring(startInt, startInt + lengthInt));
        }
        return stringResult;
    }

    public StringDataValue trim(int trimType, StringDataValue result) throws StandardException {
        int index;
        boolean found;
        int start;
        if (result == null) {
            result = this.getNewVarchar();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        char[] trimChars = new char[]{' '};
        String tmpValue = this.getString();
        if (trimType == 2) {
            for (start = 0; start < tmpValue.length(); ++start) {
                found = false;
                for (index = 0; index < trimChars.length; ++index) {
                    if (tmpValue.charAt(start) != trimChars[index]) continue;
                    found = true;
                    break;
                }
                if (!found) break;
            }
            if (start == tmpValue.length()) {
                tmpValue = "";
            } else if (start > 0) {
                tmpValue = tmpValue.substring(start);
            }
        }
        if (trimType == 1) {
            for (start = tmpValue.length(); start > 0; --start) {
                found = false;
                for (index = 0; index < trimChars.length; ++index) {
                    if (tmpValue.charAt(start - 1) != trimChars[index]) continue;
                    found = true;
                    break;
                }
                if (!found) break;
            }
            if (start == 0) {
                tmpValue = "";
            } else if (start < tmpValue.length()) {
                tmpValue = tmpValue.substring(0, start);
            }
        }
        result.setValue(tmpValue);
        return result;
    }

    private String trimInternal(int trimType, char trimChar, String source) {
        int end;
        int start;
        if (source == null) {
            return null;
        }
        int len = source.length();
        if (trimType == 2 || trimType == 0) {
            for (start = 0; start < len && trimChar == source.charAt(start); ++start) {
            }
        }
        if (start == len) {
            return "";
        }
        if (trimType == 1 || trimType == 0) {
            for (end = len - 1; end >= 0 && trimChar == source.charAt(end); --end) {
            }
        }
        if (end == -1) {
            return "";
        }
        return source.substring(start, end + 1);
    }

    public StringDataValue ansiTrim(int trimType, StringDataValue trimChar, StringDataValue result) throws StandardException {
        if (result == null) {
            result = this.getNewVarchar();
        }
        if (trimChar == null || trimChar.getString() == null) {
            result.setToNull();
            return result;
        }
        if (trimChar.getString().length() != 1) {
            throw StandardException.newException("22020", trimChar.getString());
        }
        char trimCharacter = trimChar.getString().charAt(0);
        result.setValue(this.trimInternal(trimType, trimCharacter, this.getString()));
        return result;
    }

    public StringDataValue upper(StringDataValue result) throws StandardException {
        if (result == null) {
            result = (StringDataValue)this.getNewNull();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        String upper = this.getString();
        upper = upper.toUpperCase(this.getLocale());
        result.setValue(upper);
        return result;
    }

    public StringDataValue lower(StringDataValue result) throws StandardException {
        if (result == null) {
            result = (StringDataValue)this.getNewNull();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        String lower = this.getString();
        lower = lower.toLowerCase(this.getLocale());
        result.setValue(lower);
        return result;
    }

    public int typePrecedence() {
        return 0;
    }

    protected static int stringCompare(String op1, String op2) {
        int remainingLen;
        String remainingString;
        int retvalIfLTSpace;
        int posn;
        int rightlen;
        if (op1 == null || op2 == null) {
            if (op1 != null) {
                return -1;
            }
            if (op2 != null) {
                return 1;
            }
            return 0;
        }
        int leftlen = op1.length();
        int shorterLen = leftlen < (rightlen = op2.length()) ? leftlen : rightlen;
        for (posn = 0; posn < shorterLen; ++posn) {
            char rightchar;
            char leftchar = op1.charAt(posn);
            if (leftchar == (rightchar = op2.charAt(posn))) continue;
            if (leftchar < rightchar) {
                return -1;
            }
            return 1;
        }
        if (leftlen == rightlen) {
            return 0;
        }
        if (leftlen > rightlen) {
            retvalIfLTSpace = -1;
            remainingString = op1;
            posn = rightlen;
            remainingLen = leftlen;
        } else {
            retvalIfLTSpace = 1;
            remainingString = op2;
            posn = leftlen;
            remainingLen = rightlen;
        }
        while (posn < remainingLen) {
            char remainingChar = remainingString.charAt(posn);
            if (remainingChar < ' ') {
                return retvalIfLTSpace;
            }
            if (remainingChar > ' ') {
                return -retvalIfLTSpace;
            }
            ++posn;
        }
        return 0;
    }

    protected int stringCompare(SQLChar char1, SQLChar char2) throws StandardException {
        return SQLChar.stringCompare(char1.getCharArray(), char1.getLength(), char2.getCharArray(), char2.getLength());
    }

    protected static int stringCompare(char[] op1, int leftlen, char[] op2, int rightlen) {
        int remainingLen;
        char[] remainingString;
        int retvalIfLTSpace;
        int posn;
        if (op1 == null || op2 == null) {
            if (op1 != null) {
                return -1;
            }
            if (op2 != null) {
                return 1;
            }
            return 0;
        }
        int shorterLen = leftlen < rightlen ? leftlen : rightlen;
        for (posn = 0; posn < shorterLen; ++posn) {
            char leftchar = op1[posn];
            char rightchar = op2[posn];
            if (leftchar == rightchar) continue;
            if (leftchar < rightchar) {
                return -1;
            }
            return 1;
        }
        if (leftlen == rightlen) {
            return 0;
        }
        if (leftlen > rightlen) {
            retvalIfLTSpace = -1;
            remainingString = op1;
            posn = rightlen;
            remainingLen = leftlen;
        } else {
            retvalIfLTSpace = 1;
            remainingString = op2;
            posn = leftlen;
            remainingLen = rightlen;
        }
        while (posn < remainingLen) {
            char remainingChar = remainingString[posn];
            if (remainingChar < ' ') {
                return retvalIfLTSpace;
            }
            if (remainingChar > ' ') {
                return -retvalIfLTSpace;
            }
            ++posn;
        }
        return 0;
    }

    protected int stringCollatorCompare(SQLChar str2) throws StandardException {
        CollationKey ckey1 = this.getCollationKey();
        CollationKey ckey2 = str2.getCollationKey();
        if (ckey1 == null || ckey2 == null) {
            if (ckey1 != null) {
                return -1;
            }
            if (ckey2 != null) {
                return 1;
            }
            return 0;
        }
        return ckey1.compareTo(ckey2);
    }

    protected CollationKey getCollationKey() throws StandardException {
        int lastNonspaceChar;
        char[] tmpCharArray;
        if (this.cKey != null) {
            return this.cKey;
        }
        if (this.rawLength == -1 && (tmpCharArray = this.getCharArray()) == null) {
            return null;
        }
        for (lastNonspaceChar = this.rawLength; lastNonspaceChar > 0 && this.rawData[lastNonspaceChar - 1] == ' '; --lastNonspaceChar) {
        }
        RuleBasedCollator rbc = this.getLocaleFinder().getCollator();
        this.cKey = rbc.getCollationKey(new String(this.rawData, 0, lastNonspaceChar));
        return this.cKey;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        if (this.value == null && this.rawLength != -1) {
            return new String(this.rawData, 0, this.rawLength);
        }
        if (this.stream != null) {
            try {
                return this.getString();
            }
            catch (Exception e) {
                return e.toString();
            }
        }
        return this.value;
    }

    public int hashCode() {
        int index;
        try {
            if (this.getString() == null) {
                return 0;
            }
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT("Unexpected exception", se);
            return 0;
        }
        int hashcode = 0;
        String lvalue = this.value;
        for (index = lvalue.length() - 1; index >= 0 && lvalue.charAt(index) == ' '; --index) {
        }
        while (index >= 0) {
            hashcode += lvalue.charAt(index);
            --index;
        }
        return hashcode;
    }

    protected int nationalHashCode() {
        CollationKey tmpCKey = null;
        try {
            tmpCKey = this.getCollationKey();
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT("Unexpected exception", se);
        }
        if (tmpCKey == null) {
            return 0;
        }
        return tmpCKey.hashCode();
    }

    private int[] getIntArray() throws StandardException {
        int nextInt;
        if (this.isNull()) {
            return null;
        }
        if (this.intArray != null) {
            return this.intArray;
        }
        if (this.intLength != 0) {
            SanityManager.THROWASSERT("intLength expected to be 0, not " + this.intLength);
        }
        this.intArray = new int[this.getLength()];
        RuleBasedCollator rbc = this.getLocaleFinder().getCollator();
        CollationElementIterator cei = rbc.getCollationElementIterator(this.getString());
        while ((nextInt = cei.next()) != -1) {
            if (this.intLength == this.intArray.length) {
                int[] tempArray = this.intArray;
                this.intArray = new int[this.intLength + 5];
                for (int index = 0; index < tempArray.length; ++index) {
                    this.intArray[index] = tempArray[index];
                }
            }
            this.intArray[this.intLength++] = nextInt;
        }
        return this.intArray;
    }

    private int getIntLength() {
        return this.intLength;
    }

    protected StringDataValue getNewVarchar() throws StandardException {
        return new SQLVarchar();
    }

    protected boolean isNationalString() {
        return false;
    }

    protected Date nationalGetDate(Calendar cal) throws StandardException {
        if (this.isNull()) {
            return null;
        }
        SQLDate internalDate = new SQLDate(this.getString(), false, this.getLocaleFinder(), cal);
        return internalDate.getDate(cal);
    }

    protected Time nationalGetTime(Calendar cal) throws StandardException {
        if (this.isNull()) {
            return null;
        }
        SQLTime internalTime = new SQLTime(this.getString(), false, this.getLocaleFinder(), cal);
        return internalTime.getTime(cal);
    }

    protected Timestamp nationalGetTimestamp(Calendar cal) throws StandardException {
        return SQLChar.getTimestamp(cal, this.getString(), this.getLocaleFinder());
    }

    protected void setLocaleFinder(LocaleFinder localeFinder) {
        this.localeFinder = localeFinder;
    }

    private Locale getLocale() throws StandardException {
        return this.getLocaleFinder().getCurrentLocale();
    }

    protected LocaleFinder getLocaleFinder() {
        DatabaseContext dc;
        if (this.localeFinder == null && (dc = (DatabaseContext)ContextService.getContext("Database")) != null) {
            this.localeFinder = dc.getDatabase();
        }
        return this.localeFinder;
    }

    protected DateFormat getDateFormat() throws StandardException {
        return this.getLocaleFinder().getDateFormat();
    }

    protected DateFormat getTimeFormat() throws StandardException {
        return this.getLocaleFinder().getTimeFormat();
    }

    protected DateFormat getTimestampFormat() throws StandardException {
        return this.getLocaleFinder().getTimestampFormat();
    }

    protected DateFormat getDateFormat(Calendar cal) throws StandardException {
        return this.setDateFormatCalendar(this.getLocaleFinder().getDateFormat(), cal);
    }

    protected DateFormat getTimeFormat(Calendar cal) throws StandardException {
        return this.setDateFormatCalendar(this.getLocaleFinder().getTimeFormat(), cal);
    }

    protected DateFormat getTimestampFormat(Calendar cal) throws StandardException {
        return this.setDateFormatCalendar(this.getLocaleFinder().getTimestampFormat(), cal);
    }

    private DateFormat setDateFormatCalendar(DateFormat df, Calendar cal) {
        if (cal != null && df.getTimeZone() != cal.getTimeZone()) {
            df = (DateFormat)df.clone();
            df.setCalendar(cal);
        }
        return df;
    }

    public int estimateMemoryUsage() {
        int sz = BASE_MEMORY_USAGE + ClassSize.estimateMemoryUsage(this.value);
        if (null != this.rawData) {
            sz += 2 * this.rawData.length;
        }
        if (null != this.intArray) {
            sz += this.intArray.length * ClassSize.getIntSize();
        }
        return sz;
    }

    protected void copyState(SQLChar other) {
        this.value = other.value;
        this.rawData = other.rawData;
        this.rawLength = other.rawLength;
        this.cKey = other.cKey;
        this.stream = other.stream;
        this.intArray = this.intArray;
        this.intLength = this.intLength;
        this.localeFinder = this.localeFinder;
    }

    public String getTraceString() throws StandardException {
        if (this.isNull()) {
            return "NULL";
        }
        return this.toString();
    }

    static {
        for (int i = 0; i < BLANKS.length; ++i) {
            SQLChar.BLANKS[i] = 32;
        }
        BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLChar.class);
    }
}

