/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.util.StringUtil;

public final class SQLBoolean
extends DataType
implements BooleanDataValue {
    static final int BOOLEAN_LENGTH = 1;
    private static final SQLBoolean BOOLEAN_TRUE = new SQLBoolean(true);
    private static final SQLBoolean BOOLEAN_FALSE = new SQLBoolean(false);
    static final SQLBoolean UNKNOWN = new SQLBoolean();
    private static final int BASE_MEMORY_USAGE;
    private boolean value;
    private boolean isnull;
    private boolean immutable;

    public boolean isNull() {
        return this.isnull;
    }

    public boolean getBoolean() {
        return this.value;
    }

    private static int makeInt(boolean b) {
        return b ? 1 : 0;
    }

    public byte getByte() {
        return (byte)SQLBoolean.makeInt(this.value);
    }

    public short getShort() {
        return (short)SQLBoolean.makeInt(this.value);
    }

    public int getInt() {
        return SQLBoolean.makeInt(this.value);
    }

    public long getLong() {
        return SQLBoolean.makeInt(this.value);
    }

    public float getFloat() {
        return SQLBoolean.makeInt(this.value);
    }

    public double getDouble() {
        return SQLBoolean.makeInt(this.value);
    }

    public int typeToBigDecimal() {
        return -5;
    }

    public String getString() {
        if (this.isNull()) {
            return null;
        }
        if (this.value) {
            return "true";
        }
        return "false";
    }

    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return new Boolean(this.value);
    }

    public int getLength() {
        return 1;
    }

    public String getTypeName() {
        return "BOOLEAN";
    }

    public DataValueDescriptor recycle() {
        if (this.immutable) {
            return new SQLBoolean();
        }
        return super.recycle();
    }

    public int getTypeFormatId() {
        return 77;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT(!this.isNull());
        out.writeBoolean(this.value);
    }

    public void readExternal(ObjectInput in) throws IOException {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        this.value = in.readBoolean();
        this.isnull = false;
    }

    public void readExternalFromArray(ArrayInputStream in) throws IOException {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        this.value = in.readBoolean();
        this.isnull = false;
    }

    public void restoreToNull() {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        this.value = false;
        this.isnull = true;
    }

    public int compare(DataValueDescriptor other) throws StandardException {
        if (this.typePrecedence() < other.typePrecedence()) {
            return -other.compare(this);
        }
        boolean thisNull = this.isNull();
        boolean otherNull = other.isNull();
        if (thisNull || otherNull) {
            if (!thisNull) {
                return 1;
            }
            if (!otherNull) {
                return -1;
            }
            return 0;
        }
        boolean otherValue = false;
        boolean thisValue = this.getBoolean();
        if (thisValue == (otherValue = other.getBoolean())) {
            return 0;
        }
        if (thisValue && !otherValue) {
            return 1;
        }
        return -1;
    }

    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) throws StandardException {
        if (!orderedNulls && (this.isNull() || other.isNull())) {
            return unknownRV;
        }
        return super.compare(op, other, orderedNulls, unknownRV);
    }

    public DataValueDescriptor getClone() {
        return new SQLBoolean(this.value, this.isnull);
    }

    public DataValueDescriptor getNewNull() {
        return new SQLBoolean();
    }

    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException {
        this.value = resultSet.getBoolean(colNumber);
        this.isnull = isNullable && resultSet.wasNull();
    }

    public final void setInto(PreparedStatement ps, int position) throws SQLException {
        if (this.isNull()) {
            ps.setNull(position, -7);
            return;
        }
        ps.setBoolean(position, this.value);
    }

    public SQLBoolean() {
        this.isnull = true;
    }

    public SQLBoolean(boolean val) {
        this.value = val;
    }

    public SQLBoolean(Boolean obj) {
        this.isnull = obj == null;
        if (!this.isnull) {
            this.value = obj;
        }
    }

    private SQLBoolean(boolean val, boolean isnull) {
        this.value = val;
        this.isnull = isnull;
    }

    public void setValue(boolean theValue) {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        this.value = theValue;
        this.isnull = false;
    }

    public void setValue(Boolean theValue) {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        if (theValue == null) {
            this.value = false;
            this.isnull = true;
        } else {
            this.value = theValue;
            this.isnull = false;
        }
    }

    public void setValue(byte theValue) {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        this.value = theValue != 0;
        this.isnull = false;
    }

    public void setValue(short theValue) {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        this.value = theValue != 0;
        this.isnull = false;
    }

    public void setValue(int theValue) {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        this.value = theValue != 0;
        this.isnull = false;
    }

    public void setValue(long theValue) {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        this.value = theValue != 0L;
        this.isnull = false;
    }

    public void setValue(float theValue) {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        this.value = theValue != 0.0f;
        this.isnull = false;
    }

    public void setValue(double theValue) {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        this.value = theValue != 0.0;
        this.isnull = false;
    }

    public void setBigDecimal(Number bigDecimal) throws StandardException {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        if (bigDecimal == null) {
            this.value = false;
            this.isnull = true;
        } else {
            DataValueDescriptor tempDecimal = NumberDataType.ZERO_DECIMAL.getNewNull();
            tempDecimal.setBigDecimal(bigDecimal);
            this.value = NumberDataType.ZERO_DECIMAL.compare(tempDecimal) != 0;
            this.isnull = false;
        }
    }

    public void setValue(byte[] theValue) {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        if (theValue != null) {
            this.isnull = false;
            int length = theValue.length;
            for (int i = 0; i < length; ++i) {
                if (theValue[i] == 0) continue;
                this.value = true;
                return;
            }
        } else {
            this.isnull = true;
        }
        this.value = false;
    }

    public void setValue(String theValue) throws StandardException {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        if (theValue == null) {
            this.value = false;
            this.isnull = true;
        } else {
            String cleanedValue = StringUtil.SQLToUpperCase(theValue.trim());
            if (cleanedValue.equals("TRUE")) {
                this.value = true;
            } else if (cleanedValue.equals("FALSE")) {
                this.value = false;
            } else {
                throw this.invalidFormat();
            }
            this.isnull = false;
        }
    }

    private void setValueCore(Number theValue) {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        if (theValue == null) {
            this.isnull = true;
            this.value = false;
        } else {
            this.value = theValue.intValue() != 0;
            this.isnull = false;
        }
    }

    void setObject(Object theValue) {
        this.setValue((Boolean)theValue);
    }

    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        this.setValue(theValue.getBoolean());
    }

    public BooleanDataValue equals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getBoolean() == right.getBoolean());
    }

    public BooleanDataValue notEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getBoolean() != right.getBoolean());
    }

    public BooleanDataValue lessThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean leftBoolean = left.getBoolean();
        boolean rightBoolean = right.getBoolean();
        return SQLBoolean.truthValue(left, right, !leftBoolean && rightBoolean);
    }

    public BooleanDataValue greaterThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean leftBoolean = left.getBoolean();
        boolean rightBoolean = right.getBoolean();
        return SQLBoolean.truthValue(left, right, leftBoolean && !rightBoolean);
    }

    public BooleanDataValue lessOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean leftBoolean = left.getBoolean();
        boolean rightBoolean = right.getBoolean();
        return SQLBoolean.truthValue(left, right, !leftBoolean || rightBoolean);
    }

    public BooleanDataValue greaterOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean leftBoolean = left.getBoolean();
        boolean rightBoolean = right.getBoolean();
        return SQLBoolean.truthValue(left, right, leftBoolean || !rightBoolean);
    }

    public BooleanDataValue and(BooleanDataValue otherValue) {
        if (this.equals(false) || otherValue.equals(false)) {
            return BOOLEAN_FALSE;
        }
        return SQLBoolean.truthValue((DataValueDescriptor)this, (DataValueDescriptor)otherValue, this.getBoolean() && otherValue.getBoolean());
    }

    public BooleanDataValue or(BooleanDataValue otherValue) {
        if (this.equals(true) || otherValue.equals(true)) {
            return BOOLEAN_TRUE;
        }
        return SQLBoolean.truthValue((DataValueDescriptor)this, (DataValueDescriptor)otherValue, this.getBoolean() || otherValue.getBoolean());
    }

    public BooleanDataValue is(BooleanDataValue otherValue) {
        if (this.equals(true) && otherValue.equals(true)) {
            return BOOLEAN_TRUE;
        }
        if (this.equals(false) && otherValue.equals(false)) {
            return BOOLEAN_TRUE;
        }
        if (this.isNull() && otherValue.isNull()) {
            return BOOLEAN_TRUE;
        }
        return BOOLEAN_FALSE;
    }

    public BooleanDataValue isNot(BooleanDataValue otherValue) {
        BooleanDataValue isValue = this.is(otherValue);
        if (isValue.equals(true)) {
            return BOOLEAN_FALSE;
        }
        return BOOLEAN_TRUE;
    }

    public BooleanDataValue throwExceptionIfFalse(String sqlState, String tableName, String constraintName) throws StandardException {
        if (!this.isNull() && !this.value) {
            throw StandardException.newException(sqlState, (Object)tableName, (Object)constraintName);
        }
        return this;
    }

    public int typePrecedence() {
        return 130;
    }

    public static SQLBoolean truthValue(DataValueDescriptor leftOperand, DataValueDescriptor rightOperand, boolean truth) {
        if (leftOperand.isNull() || rightOperand.isNull()) {
            return SQLBoolean.unknownTruthValue();
        }
        if (truth) {
            return BOOLEAN_TRUE;
        }
        return BOOLEAN_FALSE;
    }

    public static SQLBoolean truthValue(DataValueDescriptor leftOperand, DataValueDescriptor rightOperand, Boolean truth) {
        if (leftOperand.isNull() || rightOperand.isNull() || truth == null) {
            return SQLBoolean.unknownTruthValue();
        }
        if (truth == Boolean.TRUE) {
            return BOOLEAN_TRUE;
        }
        return BOOLEAN_FALSE;
    }

    public static SQLBoolean truthValue(boolean value) {
        if (value) {
            return BOOLEAN_TRUE;
        }
        return BOOLEAN_FALSE;
    }

    public static SQLBoolean unknownTruthValue() {
        return UNKNOWN;
    }

    public static SQLBoolean falseTruthValue() {
        return BOOLEAN_FALSE;
    }

    public static SQLBoolean trueTruthValue() {
        return BOOLEAN_TRUE;
    }

    public boolean equals(boolean val) {
        if (this.isNull()) {
            return false;
        }
        return this.value == val;
    }

    public BooleanDataValue getImmutable() {
        if (this.isNull()) {
            return UNKNOWN;
        }
        return this.value ? BOOLEAN_TRUE : BOOLEAN_FALSE;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        if (this.value) {
            return "true";
        }
        return "false";
    }

    public int hashCode() {
        if (this.isNull()) {
            return -1;
        }
        return this.value ? 1 : 0;
    }

    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }

    static {
        SQLBoolean.BOOLEAN_TRUE.immutable = true;
        SQLBoolean.BOOLEAN_FALSE.immutable = true;
        SQLBoolean.UNKNOWN.immutable = true;
        BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLBoolean.class);
    }
}

