/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.text.CollationElementIterator;
import java.text.RuleBasedCollator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;

public class Like {
    private static final char anyChar = '_';
    private static final char anyString = '%';
    private static final String SUPER_STRING = "\uffff";

    private Like() {
    }

    public static Boolean like(char[] val, int valLength, char[] pat, int patLength, char[] escape, int escapeLength, RuleBasedCollator collator) throws StandardException {
        return Like.like(val, 0, valLength, pat, 0, patLength, escape, escapeLength, collator);
    }

    public static Boolean like(int[] val, int valLength, int[] pat, int patLength, int[] escape, int escapeLength, RuleBasedCollator collator) throws StandardException {
        return Like.like(val, 0, valLength, pat, 0, patLength, escape, escapeLength, collator);
    }

    private static Boolean like(char[] val, int vLoc, int vEnd, char[] pat, int pLoc, int pEnd, char[] escape, int escapeLength, RuleBasedCollator collator) throws StandardException {
        char escChar = ' ';
        boolean haveEsc = true;
        if (val == null) {
            return null;
        }
        if (pat == null) {
            return null;
        }
        if (escape == null) {
            haveEsc = false;
        } else {
            escChar = escape[0];
        }
        while (true) {
            Boolean result;
            if ((result = Like.checkLengths(vLoc, vEnd, pLoc, pat, pEnd)) != null) {
                return result;
            }
            while (!(pat[pLoc] == '_' || pat[pLoc] == '%' || haveEsc && pat[pLoc] == escChar)) {
                if (Like.checkEquality(val, vLoc, pat, pLoc, collator)) {
                    if ((result = Like.checkLengths(++vLoc, vEnd, ++pLoc, pat, pEnd)) == null) continue;
                    return result;
                }
                return Boolean.FALSE;
            }
            if (haveEsc && pat[pLoc] == escChar) {
                if (++pLoc == pEnd) {
                    throw StandardException.newException("22025");
                }
                if (pat[pLoc] != escChar && pat[pLoc] != '_' && pat[pLoc] != '%') {
                    throw StandardException.newException("22025");
                }
                if (Like.checkEquality(val, vLoc, pat, pLoc, collator)) {
                    if ((result = Like.checkLengths(++vLoc, vEnd, ++pLoc, pat, pEnd)) == null) continue;
                    return result;
                }
                return Boolean.FALSE;
            }
            if (pat[pLoc] == '_') {
                if ((result = Like.checkLengths(++vLoc, vEnd, ++pLoc, pat, pEnd)) == null) continue;
                return result;
            }
            if (pat[pLoc] == '%') break;
        }
        if (pLoc + 1 == pEnd) {
            return Boolean.TRUE;
        }
        SanityManager.ASSERT(vLoc != vEnd, "Should have been found already");
        boolean anys = true;
        for (int i = pLoc + 1; i < pEnd; ++i) {
            if (pat[i] == '%') continue;
            anys = false;
            break;
        }
        if (anys) {
            return Boolean.TRUE;
        }
        int vRem = vEnd - vLoc;
        int n = 0;
        int minLen = Like.getMinLen(pat, pLoc + 1, pEnd, haveEsc, escChar);
        for (int i = vRem; i >= minLen; --i) {
            Boolean restResult = Like.like(val, vLoc + n, vLoc + n + i, pat, pLoc + 1, pEnd, escape, escapeLength, collator);
            if (restResult == null) {
                String vStr = new String(val, vLoc + n, i);
                String pStr = new String(pat, pLoc + 1, pEnd - (pLoc + 1));
                SanityManager.THROWASSERT("null result on like(value = " + vStr + ", pat = " + pStr + ")");
            }
            if (restResult.booleanValue()) {
                return restResult;
            }
            ++n;
        }
        return Boolean.FALSE;
    }

    private static boolean checkEquality(char[] val, int vLoc, char[] pat, int pLoc, RuleBasedCollator collator) {
        if (val[vLoc] == pat[pLoc]) {
            return true;
        }
        if (collator == null) {
            return false;
        }
        String s1 = new String(val, vLoc, 1);
        String s2 = new String(pat, pLoc, 1);
        return collator.compare(s1, s2) == 0;
    }

    private static Boolean like(int[] val, int vLoc, int vEnd, int[] pat, int pLoc, int pEnd, int[] escape, int escapeLength, RuleBasedCollator collator) throws StandardException {
        int index;
        int[] temp;
        int nextInt;
        int[] escCharInts = null;
        boolean haveEsc = true;
        int[] anyCharInts = new int[1];
        int[] anyStringInts = new int[1];
        if (val == null) {
            return null;
        }
        if (pat == null) {
            return null;
        }
        if (escape == null) {
            haveEsc = false;
        } else {
            escCharInts = escape;
        }
        CollationElementIterator cei = collator.getCollationElementIterator("_");
        anyCharInts[0] = cei.next();
        while ((nextInt = cei.next()) != -1) {
            temp = new int[anyCharInts.length + 1];
            for (index = 0; index < anyCharInts.length; ++index) {
                temp[index] = anyCharInts[index];
            }
            temp[anyCharInts.length] = nextInt;
            anyCharInts = temp;
        }
        cei = collator.getCollationElementIterator("%");
        anyStringInts[0] = cei.next();
        while ((nextInt = cei.next()) != -1) {
            temp = new int[anyStringInts.length + 1];
            for (index = 0; index < anyStringInts.length; ++index) {
                temp[index] = anyStringInts[index];
            }
            temp[anyStringInts.length] = nextInt;
            anyStringInts = temp;
        }
        while (true) {
            Boolean result;
            if ((result = Like.checkLengths(vLoc, vEnd, pLoc, pat, pEnd, anyStringInts)) != null) {
                return result;
            }
            while (!(Like.matchSpecial(pat, pLoc, pEnd, anyCharInts) || Like.matchSpecial(pat, pLoc, pEnd, anyStringInts) || haveEsc && Like.matchSpecial(pat, pLoc, pEnd, escCharInts))) {
                if (val[vLoc] == pat[pLoc]) {
                    if ((result = Like.checkLengths(++vLoc, vEnd, ++pLoc, pat, pEnd, anyStringInts)) == null) continue;
                    return result;
                }
                return Boolean.FALSE;
            }
            if (haveEsc && Like.matchSpecial(pat, pLoc, pEnd, escCharInts)) {
                if ((pLoc += escCharInts.length) == pEnd) {
                    throw StandardException.newException("22025");
                }
                int[] specialInts = null;
                if (Like.matchSpecial(pat, pLoc, pEnd, escCharInts)) {
                    specialInts = escCharInts;
                }
                if (Like.matchSpecial(pat, pLoc, pEnd, anyCharInts)) {
                    specialInts = anyCharInts;
                }
                if (Like.matchSpecial(pat, pLoc, pEnd, anyStringInts)) {
                    specialInts = anyStringInts;
                }
                if (specialInts == null) {
                    throw StandardException.newException("22025");
                }
                for (int index2 = 0; index2 < specialInts.length; ++index2) {
                    if (val[vLoc + index2] == pat[pLoc + index2]) continue;
                    return Boolean.FALSE;
                }
                result = Like.checkLengths(vLoc += specialInts.length, vEnd, pLoc += specialInts.length, pat, pEnd, anyStringInts);
                if (result == null) continue;
                return result;
            }
            if (Like.matchSpecial(pat, pLoc, pEnd, anyCharInts)) {
                result = Like.checkLengths(vLoc += anyCharInts.length, vEnd, pLoc += anyCharInts.length, pat, pEnd, anyStringInts);
                if (result == null) continue;
                return result;
            }
            if (Like.matchSpecial(pat, pLoc, pEnd, anyStringInts)) break;
        }
        if (pLoc + 1 == pEnd) {
            return Boolean.TRUE;
        }
        SanityManager.ASSERT(vLoc != vEnd, "Should have been found already");
        if (vLoc == vEnd) {
            return Boolean.TRUE;
        }
        boolean allPercentChars = true;
        for (int i = pLoc + 1; i < pEnd; ++i) {
            if (Like.matchSpecial(pat, i, pEnd, anyStringInts)) continue;
            allPercentChars = false;
            break;
        }
        if (allPercentChars) {
            return Boolean.TRUE;
        }
        int vRem = vEnd - vLoc;
        int n = 0;
        int minLen = Like.getMinLen(pat, pLoc + 1, pEnd, haveEsc, escCharInts, anyStringInts);
        for (int i = vRem; i >= minLen; --i) {
            Boolean restResult = Like.like(val, vLoc + n, vLoc + n + i, pat, pLoc + 1, pEnd, escape, escapeLength, collator);
            if (restResult == null) {
                SanityManager.THROWASSERT("null result on like(vLoc+n = " + (vLoc + n) + ", i = " + i + ", pLoc+1 = " + (pLoc + 1) + ", pEnd-(pLoc+1) = " + (pEnd - (pLoc + 1)) + ")");
            }
            if (restResult.booleanValue()) {
                return restResult;
            }
            ++n;
        }
        return Boolean.FALSE;
    }

    static int getMinLen(char[] pattern, int pStart, int pEnd, boolean haveEsc, char escChar) {
        int m = 0;
        int l = pStart;
        while (l < pEnd) {
            if (haveEsc && pattern[l] == escChar) {
                l += 2;
                ++m;
                continue;
            }
            if (pattern[l] == '%') {
                ++l;
                continue;
            }
            ++l;
            ++m;
        }
        return m;
    }

    static int getMinLen(int[] pattern, int pStart, int pEnd, boolean haveEsc, int[] escCharInts, int[] anyStringInts) {
        int m = 0;
        int l = pStart;
        while (l < pEnd) {
            if (haveEsc && Like.matchSpecial(pattern, l, pEnd, escCharInts)) {
                l += escCharInts.length + 1;
                m += escCharInts.length;
                continue;
            }
            if (Like.matchSpecial(pattern, l, pEnd, anyStringInts)) {
                l += anyStringInts.length;
                continue;
            }
            ++l;
            ++m;
        }
        return m;
    }

    static Boolean checkLengths(int vLoc, int vEnd, int pLoc, char[] pat, int pEnd) {
        if (vLoc == vEnd) {
            if (pLoc == pEnd) {
                return Boolean.TRUE;
            }
            for (int i = pLoc; i < pEnd; ++i) {
                if (pat[i] == '%') continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (pLoc == pEnd) {
            return Boolean.FALSE;
        }
        return null;
    }

    static Boolean checkLengths(int vLoc, int vEnd, int pLoc, int[] pat, int pEnd, int[] anyStringInts) {
        if (vLoc == vEnd) {
            if (pLoc == pEnd) {
                return Boolean.TRUE;
            }
            for (int i = pLoc; i < pEnd; i += anyStringInts.length) {
                if (Like.matchSpecial(pat, i, pEnd, anyStringInts)) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (pLoc == pEnd) {
            return Boolean.FALSE;
        }
        return null;
    }

    private static boolean matchSpecial(int[] pat, int patStart, int patEnd, int[] specialInts) {
        if (specialInts.length > patEnd - patStart) {
            return false;
        }
        if (specialInts.length <= patEnd - patStart) {
            for (int index = 0; index < specialInts.length; ++index) {
                if (pat[patStart + index] == specialInts[index]) continue;
                return false;
            }
        }
        return true;
    }

    public static Boolean like(char[] value, int valueLength, char[] pattern, int patternLength, RuleBasedCollator collator) throws StandardException {
        if (value == null || pattern == null) {
            return null;
        }
        return Like.like(value, valueLength, pattern, patternLength, null, 0, collator);
    }

    public static Boolean like(int[] value, int valueLength, int[] pattern, int patternLength, RuleBasedCollator collator) throws StandardException {
        if (value == null || pattern == null) {
            return null;
        }
        return Like.like(value, valueLength, pattern, patternLength, null, 0, collator);
    }

    public static boolean isOptimizable(String pattern) {
        if (pattern == null) {
            return false;
        }
        if (pattern.length() == 0) {
            return true;
        }
        char firstChar = pattern.charAt(0);
        return firstChar != '_' && firstChar != '%';
    }

    public static String greaterEqualStringFromParameter(String pattern, int maxWidth) throws StandardException {
        if (pattern == null) {
            return null;
        }
        return Like.greaterEqualString(pattern, null, maxWidth);
    }

    public static String greaterEqualStringFromParameterWithEsc(String pattern, String escape, int maxWidth) throws StandardException {
        if (pattern == null) {
            return null;
        }
        return Like.greaterEqualString(pattern, escape, maxWidth);
    }

    public static String greaterEqualString(String pattern, String escape, int maxWidth) throws StandardException {
        char escChar;
        int firstAnyChar = pattern.indexOf(95);
        int firstAnyString = pattern.indexOf(37);
        if (escape != null && escape.length() != 0 && pattern.indexOf(escChar = escape.charAt(0)) != -1) {
            return Like.padWithNulls(Like.greaterEqualString(pattern, escChar), maxWidth);
        }
        if (firstAnyChar == -1) {
            if (firstAnyString != -1) {
                pattern = pattern.substring(0, firstAnyString);
            }
        } else {
            pattern = firstAnyString == -1 ? pattern.substring(0, firstAnyChar) : pattern.substring(0, firstAnyChar > firstAnyString ? firstAnyString : firstAnyChar);
        }
        return Like.padWithNulls(pattern, maxWidth);
    }

    private static String greaterEqualString(String pattern, char escChar) throws StandardException {
        int patternLen = pattern.length();
        char[] patternChars = new char[patternLen];
        char[] result = new char[patternLen];
        pattern.getChars(0, patternLen, patternChars, 0);
        int r = 0;
        for (int p = 0; p < patternLen && r < patternLen; ++p) {
            char c = patternChars[p];
            if (c == escChar) {
                if (++p >= patternLen) {
                    throw StandardException.newException("22025");
                }
                result[r++] = patternChars[p];
                continue;
            }
            if (c == '_' || c == '%') {
                return new String(result, 0, r);
            }
            result[r++] = patternChars[p];
        }
        return new String(result, 0, r);
    }

    public static String stripEscapesNoPatternChars(String pattern, char escChar) throws StandardException {
        int patternLen = pattern.length();
        char[] patternChars = new char[patternLen];
        char[] result = new char[patternLen];
        pattern.getChars(0, patternLen, patternChars, 0);
        int r = 0;
        for (int p = 0; p < patternLen && r < patternLen; ++p) {
            char c = pattern.charAt(p);
            if (c == escChar) {
                if (++p >= patternLen) {
                    throw StandardException.newException("22025");
                }
                result[r++] = patternChars[p];
                continue;
            }
            if (c == '_' || c == '%') {
                return null;
            }
            result[r++] = patternChars[p];
        }
        return new String(result, 0, r);
    }

    public static String lessThanStringFromParameter(String pattern, int maxWidth) throws StandardException {
        if (pattern == null) {
            return null;
        }
        return Like.lessThanString(pattern, null, maxWidth);
    }

    public static String lessThanStringFromParameterWithEsc(String pattern, String escape, int maxWidth) throws StandardException {
        if (pattern == null) {
            return null;
        }
        return Like.lessThanString(pattern, escape, maxWidth);
    }

    public static String lessThanString(String pattern, String escape, int maxWidth) throws StandardException {
        char oldLastChar;
        char escChar = escape != null && escape.length() != 0 ? (char)escape.charAt(0) : (char)'\uffffffff';
        StringBuffer upperLimit = new StringBuffer(maxWidth);
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == escChar) {
                if (++i >= pattern.length()) {
                    throw StandardException.newException("22025");
                }
                c = pattern.charAt(i);
            } else if (c == '_' || c == '%') break;
            upperLimit.append(c);
        }
        if (upperLimit.length() == 0) {
            return SUPER_STRING;
        }
        int lastUsableChar = upperLimit.length() - 1;
        char newLastChar = oldLastChar = upperLimit.charAt(lastUsableChar);
        if ((newLastChar = (char)(newLastChar + '\u0001')) < oldLastChar) {
            return SUPER_STRING;
        }
        upperLimit.setCharAt(lastUsableChar, newLastChar);
        if (upperLimit.length() < maxWidth) {
            upperLimit.setLength(maxWidth);
        }
        return upperLimit.toString();
    }

    public static boolean isLikeComparisonNeeded(String pattern) {
        int firstAnyChar = pattern.indexOf(95);
        int firstAnyString = pattern.indexOf(37);
        SanityManager.ASSERT(pattern.length() != 0, "pattern expected to be non-zero length");
        if (firstAnyChar == -1 && firstAnyString == -1) {
            return false;
        }
        if (firstAnyChar != -1) {
            return true;
        }
        return firstAnyString != pattern.length() - 1;
    }

    private static String padWithNulls(String string, int len) {
        if (string.length() >= len) {
            return string;
        }
        StringBuffer buf = new StringBuffer(len).append(string);
        buf.setLength(len);
        return buf.toString();
    }
}

