/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Locale;
import java.util.Properties;
import org.apache.derby.iapi.db.DatabaseContext;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.LocaleFinder;
import org.apache.derby.iapi.services.io.RegisteredFormatIds;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.BitDataValue;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.CollatorSQLChar;
import org.apache.derby.iapi.types.CollatorSQLClob;
import org.apache.derby.iapi.types.CollatorSQLLongvarchar;
import org.apache.derby.iapi.types.CollatorSQLVarchar;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.DateTimeDataValue;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.RefDataValue;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLBit;
import org.apache.derby.iapi.types.SQLBlob;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLClob;
import org.apache.derby.iapi.types.SQLDate;
import org.apache.derby.iapi.types.SQLDouble;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLLongVarbit;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.iapi.types.SQLLongvarchar;
import org.apache.derby.iapi.types.SQLNClob;
import org.apache.derby.iapi.types.SQLNationalChar;
import org.apache.derby.iapi.types.SQLNationalLongvarchar;
import org.apache.derby.iapi.types.SQLNationalVarchar;
import org.apache.derby.iapi.types.SQLReal;
import org.apache.derby.iapi.types.SQLRef;
import org.apache.derby.iapi.types.SQLSmallint;
import org.apache.derby.iapi.types.SQLTime;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.types.SQLTinyint;
import org.apache.derby.iapi.types.SQLVarbit;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.types.UserDataValue;
import org.apache.derby.iapi.types.UserType;
import org.apache.derby.iapi.types.XML;
import org.apache.derby.iapi.types.XMLDataValue;
import org.apache.derby.impl.store.access.heap.HeapRowLocation;

abstract class DataValueFactoryImpl
implements DataValueFactory,
ModuleControl {
    LocaleFinder localeFinder;
    private Locale databaseLocale;
    private RuleBasedCollator collatorForCharacterTypes;

    DataValueFactoryImpl() {
    }

    public void boot(boolean create, Properties properties) throws StandardException {
        DataValueDescriptor decimalImplementation;
        TypeId.decimalImplementation = decimalImplementation = this.getNullDecimal(null);
        RegisteredFormatIds.TwoByte[200] = decimalImplementation.getClass().getName();
        decimalImplementation = decimalImplementation.getNewNull();
        decimalImplementation.setValue(0L);
        NumberDataType.ZERO_DECIMAL = decimalImplementation;
    }

    public void stop() {
    }

    public NumberDataValue getDataValue(int value) {
        return new SQLInteger(value);
    }

    public NumberDataValue getDataValue(int value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLInteger(value);
        }
        previous.setValue(value);
        return previous;
    }

    public NumberDataValue getDataValue(Integer value) {
        if (value != null) {
            return new SQLInteger((int)value);
        }
        return new SQLInteger();
    }

    public NumberDataValue getDataValue(Integer value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLInteger(value);
        }
        previous.setValue(value);
        return previous;
    }

    public NumberDataValue getDataValue(char value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLInteger(value);
        }
        previous.setValue(value);
        return previous;
    }

    public NumberDataValue getDataValue(short value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLSmallint(value);
        }
        previous.setValue(value);
        return previous;
    }

    public NumberDataValue getDataValue(Short value) {
        if (value != null) {
            return new SQLSmallint(value);
        }
        return new SQLSmallint();
    }

    public NumberDataValue getDataValue(Short value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return this.getDataValue(value);
        }
        previous.setValue(value);
        return previous;
    }

    public NumberDataValue getDataValue(byte value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLTinyint(value);
        }
        previous.setValue(value);
        return previous;
    }

    public NumberDataValue getDataValue(Byte value) {
        if (value != null) {
            return new SQLTinyint(value);
        }
        return new SQLTinyint();
    }

    public NumberDataValue getDataValue(Byte value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return this.getDataValue(value);
        }
        previous.setValue(value);
        return previous;
    }

    public NumberDataValue getDataValue(long value) {
        return new SQLLongint(value);
    }

    public NumberDataValue getDataValue(long value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLLongint(value);
        }
        previous.setValue(value);
        return previous;
    }

    public NumberDataValue getDataValue(Long value) {
        if (value != null) {
            return new SQLLongint((long)value);
        }
        return new SQLLongint();
    }

    public NumberDataValue getDataValue(Long value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return this.getDataValue(value);
        }
        previous.setValue(value);
        return previous;
    }

    public NumberDataValue getDataValue(float value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLReal(value);
        }
        previous.setValue(value);
        return previous;
    }

    public NumberDataValue getDataValue(Float value) throws StandardException {
        if (value != null) {
            return new SQLReal(value.floatValue());
        }
        return new SQLReal();
    }

    public NumberDataValue getDataValue(Float value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return this.getDataValue(value);
        }
        previous.setValue(value);
        return previous;
    }

    public NumberDataValue getDataValue(double value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLDouble(value);
        }
        previous.setValue(value);
        return previous;
    }

    public NumberDataValue getDataValue(Double value) throws StandardException {
        if (value != null) {
            return new SQLDouble((double)value);
        }
        return new SQLDouble();
    }

    public NumberDataValue getDataValue(Double value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return this.getDataValue(value);
        }
        previous.setValue(value);
        return previous;
    }

    public final NumberDataValue getDecimalDataValue(Number value) throws StandardException {
        NumberDataValue ndv = this.getNullDecimal(null);
        ndv.setValue(value);
        return ndv;
    }

    public final NumberDataValue getDecimalDataValue(Number value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return this.getDecimalDataValue(value);
        }
        previous.setValue(value);
        return previous;
    }

    public final NumberDataValue getDecimalDataValue(String value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return this.getDecimalDataValue(value);
        }
        previous.setValue(value);
        return previous;
    }

    public BooleanDataValue getDataValue(boolean value) {
        return new SQLBoolean(value);
    }

    public BooleanDataValue getDataValue(boolean value, BooleanDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLBoolean(value);
        }
        previous.setValue(value);
        return previous;
    }

    public BooleanDataValue getDataValue(Boolean value) {
        if (value != null) {
            return new SQLBoolean((boolean)value);
        }
        return new SQLBoolean();
    }

    public BooleanDataValue getDataValue(Boolean value, BooleanDataValue previous) throws StandardException {
        if (previous == null) {
            return this.getDataValue(value);
        }
        previous.setValue(value);
        return previous;
    }

    public BooleanDataValue getDataValue(BooleanDataValue value) {
        if (value != null) {
            return value;
        }
        return new SQLBoolean();
    }

    public BitDataValue getBitDataValue(byte[] value) throws StandardException {
        return new SQLBit(value);
    }

    public BitDataValue getBitDataValue(byte[] value, BitDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLBit(value);
        }
        previous.setValue(value);
        return previous;
    }

    public BitDataValue getVarbitDataValue(byte[] value, BitDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLVarbit(value);
        }
        previous.setValue(value);
        return previous;
    }

    public BitDataValue getLongVarbitDataValue(byte[] value, BitDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLLongVarbit(value);
        }
        previous.setValue(value);
        return previous;
    }

    public BitDataValue getBlobDataValue(byte[] value, BitDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLBlob(value);
        }
        previous.setValue(value);
        return previous;
    }

    public StringDataValue getCharDataValue(String value) {
        return new SQLChar(value);
    }

    public StringDataValue getCharDataValue(String value, StringDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLChar(value);
        }
        previous.setValue(value);
        return previous;
    }

    public StringDataValue getCharDataValue(String value, StringDataValue previous, int collationType) throws StandardException {
        if (collationType == 0) {
            return this.getCharDataValue(value, previous);
        }
        if (previous == null) {
            return new CollatorSQLChar(value, this.getCharacterCollator(collationType));
        }
        previous.setValue(value);
        return previous;
    }

    public StringDataValue getVarcharDataValue(String value) {
        return new SQLVarchar(value);
    }

    public StringDataValue getVarcharDataValue(String value, StringDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLVarchar(value);
        }
        previous.setValue(value);
        return previous;
    }

    public StringDataValue getVarcharDataValue(String value, StringDataValue previous, int collationType) throws StandardException {
        if (collationType == 0) {
            return this.getVarcharDataValue(value, previous);
        }
        if (previous == null) {
            return new CollatorSQLVarchar(value, this.getCharacterCollator(collationType));
        }
        previous.setValue(value);
        return previous;
    }

    public StringDataValue getLongvarcharDataValue(String value) {
        return new SQLLongvarchar(value);
    }

    public StringDataValue getLongvarcharDataValue(String value, StringDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLLongvarchar(value);
        }
        previous.setValue(value);
        return previous;
    }

    public StringDataValue getLongvarcharDataValue(String value, StringDataValue previous, int collationType) throws StandardException {
        if (collationType == 0) {
            return this.getLongvarcharDataValue(value, previous);
        }
        if (previous == null) {
            return new CollatorSQLLongvarchar(value, this.getCharacterCollator(collationType));
        }
        previous.setValue(value);
        return previous;
    }

    public StringDataValue getClobDataValue(String value, StringDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLClob(value);
        }
        previous.setValue(value);
        return previous;
    }

    public StringDataValue getClobDataValue(String value, StringDataValue previous, int collationType) throws StandardException {
        if (collationType == 0) {
            return this.getClobDataValue(value, previous);
        }
        if (previous == null) {
            return new CollatorSQLClob(value, this.getCharacterCollator(collationType));
        }
        previous.setValue(value);
        return previous;
    }

    public StringDataValue getNationalCharDataValue(String value) {
        return new SQLNationalChar(value, this.getLocaleFinder());
    }

    public StringDataValue getNationalCharDataValue(String value, StringDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLNationalChar(value, this.getLocaleFinder());
        }
        previous.setValue(value);
        return previous;
    }

    public StringDataValue getNationalVarcharDataValue(String value) {
        return new SQLNationalVarchar(value, this.getLocaleFinder());
    }

    public StringDataValue getNationalVarcharDataValue(String value, StringDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLNationalVarchar(value, this.getLocaleFinder());
        }
        previous.setValue(value);
        return previous;
    }

    public StringDataValue getNationalLongvarcharDataValue(String value) {
        return new SQLNationalLongvarchar(value, this.getLocaleFinder());
    }

    public StringDataValue getNationalLongvarcharDataValue(String value, StringDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLNationalLongvarchar(value, this.getLocaleFinder());
        }
        previous.setValue(value);
        return previous;
    }

    public StringDataValue getNClobDataValue(String value) {
        return new SQLNClob(value, this.getLocaleFinder());
    }

    public StringDataValue getNClobDataValue(String value, StringDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLNClob(value, this.getLocaleFinder());
        }
        previous.setValue(value);
        return previous;
    }

    public DateTimeDataValue getDataValue(Date value) throws StandardException {
        return new SQLDate(value);
    }

    public DateTimeDataValue getDataValue(Date value, DateTimeDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLDate(value);
        }
        previous.setValue(value);
        return previous;
    }

    public DateTimeDataValue getDataValue(Time value) throws StandardException {
        return new SQLTime(value);
    }

    public DateTimeDataValue getDataValue(Time value, DateTimeDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLTime(value);
        }
        previous.setValue(value);
        return previous;
    }

    public DateTimeDataValue getDataValue(Timestamp value) throws StandardException {
        return new SQLTimestamp(value);
    }

    public DateTimeDataValue getDataValue(Timestamp value, DateTimeDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLTimestamp(value);
        }
        previous.setValue(value);
        return previous;
    }

    public DateTimeDataValue getDate(DataValueDescriptor operand) throws StandardException {
        return SQLDate.computeDateFunction(operand, this);
    }

    public DateTimeDataValue getTimestamp(DataValueDescriptor operand) throws StandardException {
        return SQLTimestamp.computeTimestampFunction(operand, this);
    }

    public DateTimeDataValue getTimestamp(DataValueDescriptor date, DataValueDescriptor time) throws StandardException {
        return new SQLTimestamp(date, time);
    }

    public UserDataValue getDataValue(Object value) {
        return new UserType(value);
    }

    public UserDataValue getDataValue(Object value, UserDataValue previous) {
        if (previous == null) {
            return new UserType(value);
        }
        ((UserType)previous).setValue(value);
        return previous;
    }

    public RefDataValue getDataValue(RowLocation value, RefDataValue previous) {
        if (previous == null) {
            return new SQLRef(value);
        }
        previous.setValue(value);
        return previous;
    }

    public NumberDataValue getNullInteger(NumberDataValue dataValue) {
        if (dataValue == null) {
            return new SQLInteger();
        }
        dataValue.setToNull();
        return dataValue;
    }

    public NumberDataValue getNullShort(NumberDataValue dataValue) {
        if (dataValue == null) {
            return new SQLSmallint();
        }
        dataValue.setToNull();
        return dataValue;
    }

    public NumberDataValue getNullLong(NumberDataValue dataValue) {
        if (dataValue == null) {
            return new SQLLongint();
        }
        dataValue.setToNull();
        return dataValue;
    }

    public NumberDataValue getNullByte(NumberDataValue dataValue) {
        if (dataValue == null) {
            return new SQLTinyint();
        }
        dataValue.setToNull();
        return dataValue;
    }

    public NumberDataValue getNullFloat(NumberDataValue dataValue) {
        if (dataValue == null) {
            return new SQLReal();
        }
        dataValue.setToNull();
        return dataValue;
    }

    public NumberDataValue getNullDouble(NumberDataValue dataValue) {
        if (dataValue == null) {
            return new SQLDouble();
        }
        dataValue.setToNull();
        return dataValue;
    }

    public BooleanDataValue getNullBoolean(BooleanDataValue dataValue) {
        if (dataValue == null) {
            return new SQLBoolean();
        }
        dataValue.setToNull();
        return dataValue;
    }

    public BitDataValue getNullBit(BitDataValue dataValue) throws StandardException {
        if (dataValue == null) {
            return this.getBitDataValue(null);
        }
        dataValue.setToNull();
        return dataValue;
    }

    public BitDataValue getNullVarbit(BitDataValue dataValue) throws StandardException {
        if (dataValue == null) {
            return new SQLVarbit();
        }
        dataValue.setToNull();
        return dataValue;
    }

    public BitDataValue getNullLongVarbit(BitDataValue dataValue) throws StandardException {
        if (dataValue == null) {
            return new SQLLongVarbit();
        }
        dataValue.setToNull();
        return dataValue;
    }

    public BitDataValue getNullBlob(BitDataValue dataValue) throws StandardException {
        if (dataValue == null) {
            return new SQLBlob();
        }
        dataValue.setToNull();
        return dataValue;
    }

    public StringDataValue getNullChar(StringDataValue dataValue) {
        if (dataValue == null) {
            return this.getCharDataValue(null);
        }
        dataValue.setToNull();
        return dataValue;
    }

    public StringDataValue getNullChar(StringDataValue previous, int collationType) {
        if (collationType == 0) {
            return this.getNullChar(previous);
        }
        if (previous == null) {
            return new CollatorSQLChar(this.getCharacterCollator(collationType));
        }
        previous.setToNull();
        return previous;
    }

    public StringDataValue getNullVarchar(StringDataValue dataValue) {
        if (dataValue == null) {
            return this.getVarcharDataValue(null);
        }
        dataValue.setToNull();
        return dataValue;
    }

    public StringDataValue getNullVarchar(StringDataValue previous, int collationType) {
        if (collationType == 0) {
            return this.getNullChar(previous);
        }
        if (previous == null) {
            return new CollatorSQLVarchar(this.getCharacterCollator(collationType));
        }
        previous.setToNull();
        return previous;
    }

    public StringDataValue getNullLongvarchar(StringDataValue dataValue) {
        if (dataValue == null) {
            return this.getLongvarcharDataValue(null);
        }
        dataValue.setToNull();
        return dataValue;
    }

    public StringDataValue getNullLongvarchar(StringDataValue previous, int collationType) {
        if (collationType == 0) {
            return this.getNullChar(previous);
        }
        if (previous == null) {
            return new CollatorSQLLongvarchar(this.getCharacterCollator(collationType));
        }
        previous.setToNull();
        return previous;
    }

    public StringDataValue getNullClob(StringDataValue dataValue) {
        if (dataValue == null) {
            return new SQLClob();
        }
        dataValue.setToNull();
        return dataValue;
    }

    public StringDataValue getNullClob(StringDataValue previous, int collationType) {
        if (collationType == 0) {
            return this.getNullChar(previous);
        }
        if (previous == null) {
            return new CollatorSQLClob(this.getCharacterCollator(collationType));
        }
        previous.setToNull();
        return previous;
    }

    public StringDataValue getNullNationalChar(StringDataValue dataValue) {
        if (dataValue == null) {
            return this.getNationalCharDataValue(null);
        }
        dataValue.setToNull();
        return dataValue;
    }

    public StringDataValue getNullNationalVarchar(StringDataValue dataValue) {
        if (dataValue == null) {
            return this.getNationalVarcharDataValue(null);
        }
        dataValue.setToNull();
        return dataValue;
    }

    public StringDataValue getNullNationalLongvarchar(StringDataValue dataValue) {
        if (dataValue == null) {
            return this.getNationalLongvarcharDataValue(null);
        }
        dataValue.setToNull();
        return dataValue;
    }

    public StringDataValue getNullNClob(StringDataValue dataValue) {
        if (dataValue == null) {
            return this.getNClobDataValue(null);
        }
        dataValue.setToNull();
        return dataValue;
    }

    public UserDataValue getNullObject(UserDataValue dataValue) {
        if (dataValue == null) {
            return this.getDataValue((Object)null);
        }
        dataValue.setToNull();
        return dataValue;
    }

    public RefDataValue getNullRef(RefDataValue dataValue) {
        if (dataValue == null) {
            return new SQLRef();
        }
        dataValue.setToNull();
        return dataValue;
    }

    public DateTimeDataValue getNullDate(DateTimeDataValue dataValue) {
        if (dataValue == null) {
            try {
                return this.getDataValue((Date)null);
            }
            catch (StandardException se) {
                SanityManager.THROWASSERT("Could not get a null date.", se);
                return null;
            }
        }
        dataValue.setToNull();
        return dataValue;
    }

    public DateTimeDataValue getNullTime(DateTimeDataValue dataValue) {
        if (dataValue == null) {
            try {
                return this.getDataValue((Time)null);
            }
            catch (StandardException se) {
                SanityManager.THROWASSERT("Could not get a null time.", se);
                return null;
            }
        }
        dataValue.setToNull();
        return dataValue;
    }

    public DateTimeDataValue getNullTimestamp(DateTimeDataValue dataValue) {
        if (dataValue == null) {
            try {
                return this.getDataValue((Timestamp)null);
            }
            catch (StandardException se) {
                SanityManager.THROWASSERT("Could not get a null timestamp.", se);
                return null;
            }
        }
        dataValue.setToNull();
        return dataValue;
    }

    public DateTimeDataValue getDateValue(String dateStr, boolean isJdbcEscape) throws StandardException {
        return new SQLDate(dateStr, isJdbcEscape, this.getLocaleFinder());
    }

    public DateTimeDataValue getTimeValue(String timeStr, boolean isJdbcEscape) throws StandardException {
        return new SQLTime(timeStr, isJdbcEscape, this.getLocaleFinder());
    }

    public DateTimeDataValue getTimestampValue(String timestampStr, boolean isJdbcEscape) throws StandardException {
        return new SQLTimestamp(timestampStr, isJdbcEscape, this.getLocaleFinder());
    }

    public XMLDataValue getXMLDataValue(XMLDataValue previous) throws StandardException {
        return this.getNullXML(previous);
    }

    public XMLDataValue getNullXML(XMLDataValue dataValue) {
        if (dataValue == null) {
            return new XML();
        }
        dataValue.setToNull();
        return dataValue;
    }

    public void setLocale(Locale localeOfTheDatabase) {
        this.databaseLocale = localeOfTheDatabase;
        this.collatorForCharacterTypes = (RuleBasedCollator)Collator.getInstance(this.databaseLocale);
    }

    public RuleBasedCollator getCharacterCollator(int collationType) {
        if (collationType == 0) {
            return null;
        }
        return this.collatorForCharacterTypes;
    }

    public DataValueDescriptor getNull(int formatId, int collationType) throws StandardException {
        if (formatId == 200) {
            return this.getNullDecimal(null);
        }
        DataValueDescriptor returnDVD = DataValueFactoryImpl.getNullDVDWithUCS_BASICcollation(formatId);
        if (collationType == 0) {
            return returnDVD;
        }
        if (returnDVD instanceof StringDataValue) {
            return ((StringDataValue)returnDVD).getValue(this.getCharacterCollator(collationType));
        }
        return returnDVD;
    }

    public static DataValueDescriptor getNullDVDWithUCS_BASICcollation(int formatId) {
        switch (formatId) {
            case 87: {
                return new SQLBit();
            }
            case 77: {
                return new SQLBoolean();
            }
            case 78: {
                return new SQLChar();
            }
            case 298: {
                return new SQLDate();
            }
            case 79: {
                return new SQLDouble();
            }
            case 80: {
                return new SQLInteger();
            }
            case 84: {
                return new SQLLongint();
            }
            case 363: {
                return new SQLNationalChar();
            }
            case 365: {
                return new SQLNationalLongvarchar();
            }
            case 364: {
                return new SQLNationalVarchar();
            }
            case 81: {
                return new SQLReal();
            }
            case 82: {
                return new SQLRef();
            }
            case 83: {
                return new SQLSmallint();
            }
            case 299: {
                return new SQLTime();
            }
            case 31: {
                return new SQLTimestamp();
            }
            case 199: {
                return new SQLTinyint();
            }
            case 85: {
                return new SQLVarchar();
            }
            case 235: {
                return new SQLLongvarchar();
            }
            case 88: {
                return new SQLVarbit();
            }
            case 234: {
                return new SQLLongVarbit();
            }
            case 266: {
                return new UserType();
            }
            case 443: {
                return new SQLBlob();
            }
            case 447: {
                return new SQLClob();
            }
            case 450: {
                return new SQLNClob();
            }
            case 458: {
                return new XML();
            }
            case 90: {
                return new HeapRowLocation();
            }
        }
        return null;
    }

    private LocaleFinder getLocaleFinder() {
        DatabaseContext dc;
        if (this.localeFinder == null && (dc = (DatabaseContext)ContextService.getContext("Database")) != null) {
            this.localeFinder = dc.getDatabase();
        }
        return this.localeFinder;
    }
}

