/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import org.apache.derby.iapi.types.DataTypeDescriptor;

public abstract class DataTypeUtilities {
    public static int getPrecision(DataTypeDescriptor dtd) {
        int typeId = dtd.getTypeId().getJDBCTypeId();
        switch (typeId) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 456: 
            case 2004: 
            case 2005: {
                return dtd.getMaximumWidth();
            }
            case 5: {
                return 5;
            }
            case 16: {
                return 1;
            }
        }
        return dtd.getPrecision();
    }

    public static int getDigitPrecision(DataTypeDescriptor dtd) {
        int typeId = dtd.getTypeId().getJDBCTypeId();
        switch (typeId) {
            case 6: 
            case 8: {
                return 15;
            }
            case 7: {
                return 7;
            }
        }
        return DataTypeUtilities.getPrecision(dtd);
    }

    public static boolean isCurrency(DataTypeDescriptor dtd) {
        int typeId = dtd.getTypeId().getJDBCTypeId();
        return typeId == 3 || typeId == 2;
    }

    public static boolean isCaseSensitive(DataTypeDescriptor dtd) {
        int typeId = dtd.getTypeId().getJDBCTypeId();
        return typeId == 1 || typeId == 12 || typeId == 2005 || typeId == -1 || typeId == 456;
    }

    public static int isNullable(DataTypeDescriptor dtd) {
        return dtd.isNullable() ? 1 : 0;
    }

    public static boolean isSigned(DataTypeDescriptor dtd) {
        int typeId = dtd.getTypeId().getJDBCTypeId();
        return typeId == 4 || typeId == 6 || typeId == 3 || typeId == 5 || typeId == -5 || typeId == -6 || typeId == 2 || typeId == 7 || typeId == 8;
    }

    public static int getColumnDisplaySize(DataTypeDescriptor dtd) {
        int typeId = dtd.getTypeId().getJDBCTypeId();
        int storageLength = dtd.getMaximumWidth();
        return DataTypeUtilities.getColumnDisplaySize(typeId, storageLength);
    }

    public static int getColumnDisplaySize(int typeId, int storageLength) {
        int size;
        switch (typeId) {
            case 93: {
                size = 26;
                break;
            }
            case 91: {
                size = 10;
                break;
            }
            case 92: {
                size = 8;
                break;
            }
            case 4: {
                size = 11;
                break;
            }
            case 5: {
                size = 6;
                break;
            }
            case 6: 
            case 7: {
                size = 13;
                break;
            }
            case 8: {
                size = 22;
                break;
            }
            case -6: {
                size = 15;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                size = 2 * storageLength;
                if (size >= 0) break;
                size = Integer.MAX_VALUE;
                break;
            }
            case -5: {
                size = 20;
                break;
            }
            case -7: 
            case 16: {
                size = 5;
                break;
            }
            default: {
                int w = storageLength;
                size = w > 0 ? w : 15;
            }
        }
        return size;
    }

    public static int computeMaxWidth(int precision, int scale) {
        return scale == 0 ? precision + 1 : (scale == precision ? precision + 3 : precision + 2);
    }
}

