/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Timestamp;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueSQLObjectDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;

public class TriggerDescriptor
extends TupleDescriptor
implements UniqueSQLObjectDescriptor,
Provider,
Dependent,
Formatable {
    public static final int SYSTRIGGERS_STATE_FIELD = 8;
    public static final int TRIGGER_EVENT_UPDATE = 1;
    public static final int TRIGGER_EVENT_DELETE = 2;
    public static final int TRIGGER_EVENT_INSERT = 4;
    private UUID id;
    private String name;
    private String oldReferencingName;
    private String newReferencingName;
    private String triggerDefinition;
    private SchemaDescriptor sd;
    private int eventMask;
    private boolean isBefore;
    private boolean isRow;
    private boolean referencingOld;
    private boolean referencingNew;
    private TableDescriptor td;
    private UUID actionSPSId;
    private SPSDescriptor actionSPS;
    private UUID whenSPSId;
    private SPSDescriptor whenSPS;
    private boolean isEnabled;
    private int[] referencedCols;
    private Timestamp creationTimestamp;
    private UUID triggerSchemaId;
    private UUID triggerTableId;

    public TriggerDescriptor() {
    }

    public TriggerDescriptor(DataDictionary dataDictionary, SchemaDescriptor sd, UUID id, String name, int eventMask, boolean isBefore, boolean isRow, boolean isEnabled, TableDescriptor td, UUID whenSPSId, UUID actionSPSId, Timestamp creationTimestamp, int[] referencedCols, String triggerDefinition, boolean referencingOld, boolean referencingNew, String oldReferencingName, String newReferencingName) {
        super(dataDictionary);
        this.id = id;
        this.sd = sd;
        this.name = name;
        this.eventMask = eventMask;
        this.isBefore = isBefore;
        this.isRow = isRow;
        this.td = td;
        this.actionSPSId = actionSPSId;
        this.whenSPSId = whenSPSId;
        this.isEnabled = isEnabled;
        this.referencedCols = referencedCols;
        this.creationTimestamp = creationTimestamp;
        this.triggerDefinition = triggerDefinition;
        this.referencingOld = referencingOld;
        this.referencingNew = referencingNew;
        this.oldReferencingName = oldReferencingName;
        this.newReferencingName = newReferencingName;
        this.triggerSchemaId = sd.getUUID();
        this.triggerTableId = td.getUUID();
    }

    public UUID getUUID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public UUID getTableId() {
        return this.triggerTableId;
    }

    public SchemaDescriptor getSchemaDescriptor() throws StandardException {
        if (this.sd == null) {
            this.sd = this.getDataDictionary().getSchemaDescriptor(this.triggerSchemaId, null);
        }
        return this.sd;
    }

    public boolean listensForEvent(int event) {
        return (event & this.eventMask) == event;
    }

    public int getTriggerEventMask() {
        return this.eventMask;
    }

    public Timestamp getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public boolean isBeforeTrigger() {
        return this.isBefore;
    }

    public boolean isRowTrigger() {
        return this.isRow;
    }

    public UUID getActionId() {
        return this.actionSPSId;
    }

    public SPSDescriptor getActionSPS(LanguageConnectionContext lcc) throws StandardException {
        if (this.actionSPS == null) {
            lcc.beginNestedTransaction(true);
            this.actionSPS = this.getDataDictionary().getSPSDescriptor(this.actionSPSId);
            lcc.commitNestedTransaction();
        }
        return this.actionSPS;
    }

    public UUID getWhenClauseId() {
        return this.whenSPSId;
    }

    public SPSDescriptor getWhenClauseSPS() throws StandardException {
        if (this.whenSPS == null) {
            this.whenSPS = this.getDataDictionary().getSPSDescriptor(this.whenSPSId);
        }
        return this.whenSPS;
    }

    public TableDescriptor getTableDescriptor() throws StandardException {
        if (this.td == null) {
            this.td = this.getDataDictionary().getTableDescriptor(this.triggerTableId);
        }
        return this.td;
    }

    public int[] getReferencedCols() {
        return this.referencedCols;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled() {
        this.isEnabled = true;
    }

    public void setDisabled() {
        this.isEnabled = false;
    }

    public boolean needsToFire(int stmtType, int[] modifiedCols) throws StandardException {
        if (stmtType != 1 && stmtType != 2 && stmtType != 3 && stmtType != 4) {
            SanityManager.THROWASSERT("invalid statement type " + stmtType);
        }
        if (!this.isEnabled) {
            return false;
        }
        if (stmtType == 1) {
            return (this.eventMask & 4) == this.eventMask;
        }
        if (stmtType == 4) {
            return (this.eventMask & 2) == this.eventMask;
        }
        if (stmtType == 2) {
            throw StandardException.newException("42Z08", (Object)this.getTableDescriptor().getQualifiedName(), (Object)this.name);
        }
        return (this.eventMask & 1) == this.eventMask && ConstraintDescriptor.doColumnsIntersect(modifiedCols, this.referencedCols);
    }

    public String getTriggerDefinition() {
        return this.triggerDefinition;
    }

    public boolean getReferencingOld() {
        return this.referencingOld;
    }

    public boolean getReferencingNew() {
        return this.referencingNew;
    }

    public String getOldReferencingName() {
        return this.oldReferencingName;
    }

    public String getNewReferencingName() {
        return this.newReferencingName;
    }

    public String toString() {
        return "TRIGGER: " + this.name;
    }

    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(320);
    }

    public String getObjectName() {
        return this.name;
    }

    public UUID getObjectID() {
        return this.id;
    }

    public String getClassType() {
        return "Trigger";
    }

    public synchronized boolean isValid() {
        return true;
    }

    public void prepareToInvalidate(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
        switch (action) {
            case 1: 
            case 13: 
            case 34: 
            case 43: 
            case 45: {
                DependencyManager dm = this.getDataDictionary().getDependencyManager();
                throw StandardException.newException("X0Y25.S", dm.getActionString(action), (Object)p.getObjectName(), (Object)"TRIGGER", (Object)this.name);
            }
        }
    }

    public void makeInvalid(int action, LanguageConnectionContext lcc) throws StandardException {
        switch (action) {
            case 14: {
                DependencyManager dm = this.getDataDictionary().getDependencyManager();
                dm.invalidateFor(this, 11, lcc);
                break;
            }
            case 44: {
                this.drop(lcc);
                break;
            }
        }
    }

    public void drop(LanguageConnectionContext lcc) throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        DependencyManager dm = this.getDataDictionary().getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        dm.invalidateFor(this, 27, lcc);
        dd.dropTriggerDescriptor(this, tc);
        dm.clearDependencies(lcc, this);
        SPSDescriptor spsd = dd.getSPSDescriptor(this.getActionId());
        dm.invalidateFor(spsd, 27, lcc);
        dm.clearDependencies(lcc, spsd);
        dd.dropSPSDescriptor(spsd, tc);
        if (this.getWhenClauseId() != null) {
            spsd = dd.getSPSDescriptor(this.getWhenClauseId());
            dm.invalidateFor(spsd, 27, lcc);
            dm.clearDependencies(lcc, spsd);
            dd.dropSPSDescriptor(spsd, tc);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = (UUID)in.readObject();
        this.name = (String)in.readObject();
        this.triggerSchemaId = (UUID)in.readObject();
        this.triggerTableId = (UUID)in.readObject();
        this.eventMask = in.readInt();
        this.isBefore = in.readBoolean();
        this.isRow = in.readBoolean();
        this.isEnabled = in.readBoolean();
        this.whenSPSId = (UUID)in.readObject();
        this.actionSPSId = (UUID)in.readObject();
        int length = in.readInt();
        if (length != 0) {
            this.referencedCols = new int[length];
            for (int i = 0; i < length; ++i) {
                this.referencedCols[i] = in.readInt();
            }
        }
        this.triggerDefinition = (String)in.readObject();
        this.referencingOld = in.readBoolean();
        this.referencingNew = in.readBoolean();
        this.oldReferencingName = (String)in.readObject();
        this.newReferencingName = (String)in.readObject();
    }

    protected DataDictionary getDataDictionary() {
        DataDictionary dd = super.getDataDictionary();
        if (dd == null) {
            LanguageConnectionContext lcc = (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
            dd = lcc.getDataDictionary();
            this.setDataDictionary(dd);
        }
        return dd;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT(this.triggerSchemaId != null, "triggerSchemaId expected to be non-null");
        SanityManager.ASSERT(this.triggerTableId != null, "triggerTableId expected to be non-null");
        out.writeObject(this.id);
        out.writeObject(this.name);
        out.writeObject(this.triggerSchemaId);
        out.writeObject(this.triggerTableId);
        out.writeInt(this.eventMask);
        out.writeBoolean(this.isBefore);
        out.writeBoolean(this.isRow);
        out.writeBoolean(this.isEnabled);
        out.writeObject(this.whenSPSId);
        out.writeObject(this.actionSPSId);
        if (this.referencedCols == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.referencedCols.length);
            for (int i = 0; i < this.referencedCols.length; ++i) {
                out.writeInt(this.referencedCols[i]);
            }
        }
        out.writeObject(this.triggerDefinition);
        out.writeBoolean(this.referencingOld);
        out.writeBoolean(this.referencingNew);
        out.writeObject(this.oldReferencingName);
        out.writeObject(this.newReferencingName);
    }

    public int getTypeFormatId() {
        return 316;
    }

    public String getDescriptorType() {
        return "Trigger";
    }

    public String getDescriptorName() {
        return this.name;
    }
}

