/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TablePermsDescriptor;

public class StatementTablePermission
extends StatementPermission {
    UUID tableUUID;
    int privType;

    public StatementTablePermission(UUID tableUUID, int privType) {
        this.tableUUID = tableUUID;
        this.privType = privType;
    }

    public int getPrivType() {
        return this.privType;
    }

    public UUID getTableUUID() {
        return this.tableUUID;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass().equals(obj.getClass())) {
            StatementTablePermission other = (StatementTablePermission)obj;
            return this.privType == other.privType && this.tableUUID.equals(other.tableUUID);
        }
        return false;
    }

    public int hashCode() {
        return this.privType + this.tableUUID.hashCode();
    }

    public void check(LanguageConnectionContext lcc, String authorizationId, boolean forGrant) throws StandardException {
        DataDictionary dd = lcc.getDataDictionary();
        if (!this.hasPermissionOnTable(dd, authorizationId, forGrant)) {
            TableDescriptor td = this.getTableDescriptor(dd);
            throw StandardException.newException(forGrant ? "42501" : "42500", authorizationId, (Object)this.getPrivName(), (Object)td.getSchemaName(), (Object)td.getName());
        }
    }

    protected TableDescriptor getTableDescriptor(DataDictionary dd) throws StandardException {
        TableDescriptor td = dd.getTableDescriptor(this.tableUUID);
        if (td == null) {
            throw StandardException.newException("4250E", "table");
        }
        return td;
    }

    protected boolean hasPermissionOnTable(DataDictionary dd, String authorizationId, boolean forGrant) throws StandardException {
        return this.oneAuthHasPermissionOnTable(dd, "PUBLIC", forGrant) || this.oneAuthHasPermissionOnTable(dd, authorizationId, forGrant);
    }

    protected boolean oneAuthHasPermissionOnTable(DataDictionary dd, String authorizationId, boolean forGrant) throws StandardException {
        TablePermsDescriptor perms = dd.getTablePermissions(this.tableUUID, authorizationId);
        if (perms == null) {
            return false;
        }
        String priv = null;
        switch (this.privType) {
            case 0: {
                priv = perms.getSelectPriv();
                break;
            }
            case 1: {
                priv = perms.getUpdatePriv();
                break;
            }
            case 2: {
                priv = perms.getReferencesPriv();
                break;
            }
            case 3: {
                priv = perms.getInsertPriv();
                break;
            }
            case 4: {
                priv = perms.getDeletePriv();
                break;
            }
            case 5: {
                priv = perms.getTriggerPriv();
            }
        }
        return "Y".equals(priv) || !forGrant && "y".equals(priv);
    }

    public PermissionsDescriptor getPermissionDescriptor(String authid, DataDictionary dd) throws StandardException {
        if (this.oneAuthHasPermissionOnTable(dd, authid, false)) {
            return dd.getTablePermissions(this.tableUUID, authid);
        }
        return null;
    }

    public String getPrivName() {
        switch (this.privType) {
            case 0: {
                return "select";
            }
            case 1: {
                return "update";
            }
            case 2: {
                return "references";
            }
            case 3: {
                return "insert";
            }
            case 4: {
                return "delete";
            }
            case 5: {
                return "trigger";
            }
        }
        return "?";
    }
}

