/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.store.access.TransactionController;

public class StatementSchemaPermission
extends StatementPermission {
    private String schemaName;
    private String aid;
    private int privType;

    public StatementSchemaPermission(String schemaName, String aid, int privType) {
        this.schemaName = schemaName;
        this.aid = aid;
        this.privType = privType;
    }

    public void check(LanguageConnectionContext lcc, String authid, boolean forGrant) throws StandardException {
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        switch (this.privType) {
            case 17: 
            case 18: {
                SchemaDescriptor sd = dd.getSchemaDescriptor(this.schemaName, tc, false);
                if (sd == null) {
                    return;
                }
                if (authid.equals(sd.getAuthorizationId())) break;
                throw StandardException.newException("42507", (Object)authid, (Object)this.schemaName);
            }
            case 16: {
                if (this.schemaName.equals(authid) && (this.aid == null || this.aid.equals(authid))) break;
                throw StandardException.newException("42508", (Object)authid, (Object)this.schemaName);
            }
            default: {
                SanityManager.THROWASSERT("Unexpected value (" + this.privType + ") for privType");
            }
        }
    }

    public PermissionsDescriptor getPermissionDescriptor(String authid, DataDictionary dd) throws StandardException {
        return null;
    }
}

