/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoutinePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.store.access.TransactionController;

public final class StatementRoutinePermission
extends StatementPermission {
    private UUID routineUUID;

    public StatementRoutinePermission(UUID routineUUID) {
        this.routineUUID = routineUUID;
    }

    public void check(LanguageConnectionContext lcc, String authorizationId, boolean forGrant) throws StandardException {
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        RoutinePermsDescriptor perms = dd.getRoutinePermissions(this.routineUUID, authorizationId);
        if (perms == null || !perms.getHasExecutePermission()) {
            perms = dd.getRoutinePermissions(this.routineUUID, "PUBLIC");
        }
        if (perms == null || !perms.getHasExecutePermission()) {
            AliasDescriptor ad = dd.getAliasDescriptor(this.routineUUID);
            if (ad == null) {
                throw StandardException.newException("4250E", "routine");
            }
            SchemaDescriptor sd = dd.getSchemaDescriptor(ad.getSchemaUUID(), tc);
            if (sd == null) {
                throw StandardException.newException("4250E", "schema");
            }
            throw StandardException.newException(forGrant ? "42505" : "42504", authorizationId, (Object)ad.getDescriptorType(), (Object)sd.getSchemaName(), (Object)ad.getDescriptorName());
        }
    }

    public PermissionsDescriptor getPermissionDescriptor(String authid, DataDictionary dd) throws StandardException {
        return dd.getRoutinePermissions(this.routineUUID, authid);
    }
}

