/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ColPermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementTablePermission;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

public class StatementColumnPermission
extends StatementTablePermission {
    private FormatableBitSet columns;

    public StatementColumnPermission(UUID tableUUID, int privType, FormatableBitSet columns) {
        super(tableUUID, privType);
        this.columns = columns;
    }

    public FormatableBitSet getColumns() {
        return this.columns;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StatementColumnPermission) {
            StatementColumnPermission other = (StatementColumnPermission)obj;
            if (!this.columns.equals(other.columns)) {
                return false;
            }
            return super.equals(obj);
        }
        return false;
    }

    public void check(LanguageConnectionContext lcc, String authorizationId, boolean forGrant) throws StandardException {
        DataDictionary dd = lcc.getDataDictionary();
        if (this.hasPermissionOnTable(dd, authorizationId, forGrant)) {
            return;
        }
        FormatableBitSet permittedColumns = null;
        if (!forGrant) {
            permittedColumns = this.addPermittedColumns(dd, false, "PUBLIC", permittedColumns);
            permittedColumns = this.addPermittedColumns(dd, false, authorizationId, permittedColumns);
        }
        permittedColumns = this.addPermittedColumns(dd, true, "PUBLIC", permittedColumns);
        permittedColumns = this.addPermittedColumns(dd, true, authorizationId, permittedColumns);
        int i = this.columns.anySetBit();
        while (i >= 0) {
            if (permittedColumns == null || !permittedColumns.get(i)) {
                TableDescriptor td = this.getTableDescriptor(dd);
                ColumnDescriptor cd = td.getColumnDescriptor(i + 1);
                if (cd == null) {
                    throw StandardException.newException("4250E", "column");
                }
                throw StandardException.newException(forGrant ? "42503" : "42502", authorizationId, (Object)this.getPrivName(), (Object)cd.getColumnName(), (Object)td.getSchemaName(), (Object)td.getName());
            }
            i = this.columns.anySetBit(i);
        }
    }

    private FormatableBitSet addPermittedColumns(DataDictionary dd, boolean forGrant, String authorizationId, FormatableBitSet permittedColumns) throws StandardException {
        if (permittedColumns != null && permittedColumns.getNumBitsSet() == permittedColumns.size()) {
            return permittedColumns;
        }
        ColPermsDescriptor perms = dd.getColumnPermissions(this.tableUUID, this.privType, false, authorizationId);
        if (perms != null) {
            if (permittedColumns == null) {
                return perms.getColumns();
            }
            permittedColumns.or(perms.getColumns());
        }
        return permittedColumns;
    }

    public PermissionsDescriptor getPermissionDescriptor(String authid, DataDictionary dd) throws StandardException {
        if (this.oneAuthHasPermissionOnTable(dd, authid, false)) {
            return dd.getTablePermissions(this.tableUUID, authid);
        }
        if (this.oneAuthHasPermissionOnTable(dd, "PUBLIC", false)) {
            return dd.getTablePermissions(this.tableUUID, "PUBLIC");
        }
        ColPermsDescriptor colsPermsDesc = dd.getColumnPermissions(this.tableUUID, this.privType, false, authid);
        if (colsPermsDesc != null && colsPermsDesc.getColumns() != null) {
            FormatableBitSet permittedColumns = colsPermsDesc.getColumns();
            int i = this.columns.anySetBit();
            while (i >= 0) {
                if (permittedColumns.get(i)) {
                    return colsPermsDesc;
                }
                i = this.columns.anySetBit(i);
            }
        }
        return null;
    }

    public PermissionsDescriptor getPUBLIClevelColPermsDescriptor(String authid, DataDictionary dd) throws StandardException {
        ColPermsDescriptor colsPermsDesc = dd.getColumnPermissions(this.tableUUID, this.privType, false, authid);
        FormatableBitSet permittedColumns = colsPermsDesc.getColumns();
        boolean allColumnsCoveredByUserLevelPrivilege = true;
        int i = this.columns.anySetBit();
        while (i >= 0 && allColumnsCoveredByUserLevelPrivilege) {
            if (!permittedColumns.get(i)) {
                allColumnsCoveredByUserLevelPrivilege = false;
            }
            i = this.columns.anySetBit(i);
        }
        if (allColumnsCoveredByUserLevelPrivilege) {
            return null;
        }
        return dd.getColumnPermissions(this.tableUUID, this.privType, false, "PUBLIC");
    }
}

