/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.Statement;
import org.apache.derby.iapi.sql.StorablePreparedStatement;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueSQLObjectDescriptor;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.catalog.DataDictionaryImpl;

public class SPSDescriptor
extends TupleDescriptor
implements UniqueSQLObjectDescriptor,
Dependent,
Provider {
    public static final char SPS_TYPE_TRIGGER = 'T';
    public static final char SPS_TYPE_REGULAR = 'S';
    public static final char SPS_TYPE_EXPLAIN = 'X';
    private static final int RECOMPILE = 1;
    private static final int INVALIDATE = 0;
    private SchemaDescriptor sd;
    private String name;
    private UUID uuid;
    private UUID compSchemaId;
    private char type;
    private boolean valid;
    private String text;
    private String usingText;
    private ExecPreparedStatement preparedStatement;
    private DataTypeDescriptor[] params;
    private Timestamp compileTime;
    private Object[] paramDefaults;
    private boolean initiallyCompilable;
    private boolean lookedUpParams;
    private UUIDFactory uuidFactory;

    public SPSDescriptor(DataDictionary dataDictionary, String name, UUID uuid, UUID suuid, UUID compSchemaUUID, char type, boolean valid, String text, boolean initiallyCompilable) throws StandardException {
        this(dataDictionary, name, uuid, suuid, compSchemaUUID, type, valid, text, null, null, null, initiallyCompilable);
    }

    public SPSDescriptor(DataDictionary dataDictionary, String name, UUID uuid, UUID suuid, UUID compSchemaUUID, char type, boolean valid, String text, String usingText, Timestamp compileTime, ExecPreparedStatement preparedStatement, boolean initiallyCompilable) throws StandardException {
        super(dataDictionary);
        this.name = name;
        this.uuid = uuid;
        this.type = type;
        this.text = text;
        this.usingText = usingText;
        this.valid = valid;
        this.compileTime = compileTime;
        this.sd = dataDictionary.getSchemaDescriptor(suuid, null);
        this.preparedStatement = preparedStatement;
        this.compSchemaId = compSchemaUUID;
        this.initiallyCompilable = initiallyCompilable;
    }

    public final synchronized void prepareAndRelease(LanguageConnectionContext lcc, TableDescriptor triggerTable, TransactionController tc) throws StandardException {
        if (triggerTable != null) {
            SanityManager.ASSERT(this.type == 'T', "only expect a table descriptor when we have a trigger");
        }
        this.compileStatement(lcc, triggerTable, tc);
        this.preparedStatement.makeInvalid(11, lcc);
    }

    public final synchronized void prepareAndRelease(LanguageConnectionContext lcc, TableDescriptor triggerTable) throws StandardException {
        this.prepareAndRelease(lcc, triggerTable, null);
    }

    public final synchronized void prepareAndRelease(LanguageConnectionContext lcc) throws StandardException {
        this.prepareAndRelease(lcc, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileStatement(LanguageConnectionContext lcc, TableDescriptor triggerTable, TransactionController tc) throws StandardException {
        String uuidStr;
        ContextManager cm = lcc.getContextManager();
        LanguageConnectionFactory lcf = lcc.getLanguageConnectionFactory();
        DataDictionary dd = this.getDataDictionary();
        if (this.type == 'T' && triggerTable == null && (triggerTable = dd.getTableDescriptor(this.recreateUUID(uuidStr = this.name.substring(49)))) == null) {
            SanityManager.THROWASSERT("couldn't find trigger table for trigger sps " + this.name);
        }
        if (triggerTable != null) {
            lcc.pushTriggerTable(triggerTable);
        }
        Statement stmt = lcf.getStatement(dd.getSchemaDescriptor(this.compSchemaId, null), this.text, true);
        try {
            this.preparedStatement = (ExecPreparedStatement)stmt.prepareStorable(lcc, this.preparedStatement, this.getParameterDefaults(), this.getSchemaDescriptor(), this.type == 'T');
        }
        finally {
            if (triggerTable != null) {
                lcc.popTriggerTable(triggerTable);
            }
        }
        if (this.preparedStatement.referencesSessionSchema()) {
            throw StandardException.newException("XCL51.S");
        }
        this.setCompileTime();
        this.setParams(this.preparedStatement.getParameterTypes());
        if (!((DataDictionaryImpl)dd).readOnlyUpgrade) {
            dd.startWriting(lcc);
            DependencyManager dm = dd.getDependencyManager();
            dm.clearDependencies(lcc, this, tc);
            dm.copyDependencies(this.preparedStatement, this, false, cm, tc);
        }
        this.valid = true;
    }

    public final String getName() {
        return this.name;
    }

    public final String getQualifiedName() {
        return this.sd.getSchemaName() + "." + this.name;
    }

    public final SchemaDescriptor getSchemaDescriptor() {
        return this.sd;
    }

    public final char getType() {
        return this.type;
    }

    public final String getTypeAsString() {
        char[] charArray = new char[]{this.type};
        return new String(charArray);
    }

    public boolean initiallyCompilable() {
        return this.initiallyCompilable;
    }

    public static final boolean validType(char type) {
        return type == 'S' || type == 'T';
    }

    public final synchronized Timestamp getCompileTime() {
        return this.compileTime;
    }

    public final synchronized void setCompileTime() {
        this.compileTime = new Timestamp(System.currentTimeMillis());
    }

    public final String getText() {
        return this.text;
    }

    public final synchronized String getUsingText() {
        return this.usingText;
    }

    public final synchronized void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public final UUID getUUID() {
        return this.uuid;
    }

    public final synchronized DataTypeDescriptor[] getParams() throws StandardException {
        if (this.params == null && !this.lookedUpParams) {
            Vector v = new Vector();
            this.params = this.getDataDictionary().getSPSParams(this, v);
            this.paramDefaults = new Object[v.size()];
            Enumeration iterator = v.elements();
            int i = 0;
            while (iterator.hasMoreElements()) {
                this.paramDefaults[i] = iterator.nextElement();
                ++i;
            }
            this.lookedUpParams = true;
        }
        return this.params;
    }

    public final synchronized void setParams(DataTypeDescriptor[] params) {
        this.params = params;
    }

    public final synchronized Object[] getParameterDefaults() throws StandardException {
        if (this.paramDefaults == null) {
            this.getParams();
        }
        return this.paramDefaults;
    }

    public final synchronized void setParameterDefaults(Object[] values) {
        this.paramDefaults = values;
    }

    public final ExecPreparedStatement getPreparedStatement() throws StandardException {
        return this.getPreparedStatement(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized ExecPreparedStatement getPreparedStatement(boolean recompIfInvalid) throws StandardException {
        block12: {
            if (recompIfInvalid && (!this.valid || this.preparedStatement == null)) {
                ContextManager cm = ContextService.getFactory().getCurrentContextManager();
                LanguageConnectionContext lcc = (LanguageConnectionContext)cm.getContext("LanguageConnectionContext");
                if (!((DataDictionaryImpl)lcc.getDataDictionary()).readOnlyUpgrade) {
                    TransactionController nestedTC;
                    try {
                        nestedTC = lcc.getTransactionCompile().startNestedUserTransaction(false);
                    }
                    catch (StandardException se) {
                        nestedTC = null;
                    }
                    boolean compilable = this.initiallyCompilable;
                    try {
                        this.prepareAndRelease(lcc, null, nestedTC);
                        this.updateSYSSTATEMENTS(lcc, 1, nestedTC);
                    }
                    catch (StandardException se) {
                        if (se.getMessageId().equals("40XL1")) {
                            if (nestedTC != null) {
                                nestedTC.commit();
                                nestedTC.destroy();
                                nestedTC = null;
                            }
                            this.initiallyCompilable = compilable;
                            this.prepareAndRelease(lcc, null, null);
                            this.updateSYSSTATEMENTS(lcc, 1, null);
                            break block12;
                        }
                        throw se;
                    }
                    finally {
                        if (nestedTC != null) {
                            nestedTC.commit();
                            nestedTC.destroy();
                        }
                    }
                }
            }
        }
        return this.preparedStatement;
    }

    public final UUID getCompSchemaId() {
        return this.compSchemaId;
    }

    public final String toString() {
        return "SPSDescriptor:\n\tname: " + this.sd.getSchemaName() + "." + this.name + "\n" + "\tuuid: " + this.uuid + "\n" + "\ttext: " + this.text + "\n" + "\tvalid: " + (this.valid ? "TRUE" : "FALSE") + "\n" + "\tpreparedStatement: " + this.preparedStatement + "\n";
    }

    public final DependableFinder getDependableFinder() {
        return this.getDependableFinder(226);
    }

    public final String getObjectName() {
        return this.name;
    }

    public final UUID getObjectID() {
        return this.uuid;
    }

    public final String getClassType() {
        return "StoredPreparedStatement";
    }

    public final synchronized boolean isValid() {
        return this.valid;
    }

    public final synchronized void prepareToInvalidate(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
        switch (action) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: {
                break;
            }
            default: {
                DependencyManager dm = this.getDataDictionary().getDependencyManager();
                throw StandardException.newException("X0Y24.S", (Object)dm.getActionString(action), (Object)p.getObjectName(), (Object)this.name);
            }
        }
    }

    public final synchronized void makeInvalid(int action, LanguageConnectionContext lcc) throws StandardException {
        DependencyManager dm = this.getDataDictionary().getDependencyManager();
        switch (action) {
            case 10: 
            case 11: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: {
                if (this.valid) {
                    this.valid = false;
                    this.updateSYSSTATEMENTS(lcc, 0, null);
                }
                dm.invalidateFor(this, 14, lcc);
                break;
            }
            case 13: {
                dm.clearDependencies(lcc, this);
                break;
            }
            default: {
                SanityManager.THROWASSERT("makeInvalid(" + dm.getActionString(action) + ") not expected to get called; should have failed in " + "prepareToInvalidate()");
            }
        }
    }

    public final synchronized void revalidate(LanguageConnectionContext lcc) throws StandardException {
        this.valid = false;
        this.makeInvalid(14, lcc);
        this.prepareAndRelease(lcc);
        this.updateSYSSTATEMENTS(lcc, 1, null);
    }

    public void loadGeneratedClass() throws StandardException {
        if (this.preparedStatement != null) {
            ((StorablePreparedStatement)this.preparedStatement).loadGeneratedClass();
        }
    }

    private void updateSYSSTATEMENTS(LanguageConnectionContext lcc, int mode, TransactionController tc) throws StandardException {
        boolean updateSYSCOLUMNS;
        boolean recompile;
        boolean wait = false;
        boolean firstCompilation = false;
        if (mode == 1) {
            recompile = true;
            updateSYSCOLUMNS = true;
            if (!this.initiallyCompilable) {
                firstCompilation = true;
                this.initiallyCompilable = true;
            }
        } else {
            recompile = false;
            updateSYSCOLUMNS = false;
        }
        DataDictionary dd = this.getDataDictionary();
        if (((DataDictionaryImpl)dd).readOnlyUpgrade) {
            return;
        }
        dd.startWriting(lcc);
        if (tc == null) {
            tc = lcc.getTransactionExecute();
            wait = true;
        }
        dd.updateSPS(this, tc, recompile, updateSYSCOLUMNS, wait, firstCompilation);
    }

    private UUID recreateUUID(String idString) {
        if (this.uuidFactory == null) {
            this.uuidFactory = Monitor.getMonitor().getUUIDFactory();
        }
        return this.uuidFactory.recreateUUID(idString);
    }

    public String getDescriptorType() {
        return "Statement";
    }

    public String getDescriptorName() {
        return this.name;
    }
}

