/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

public class IndexLister {
    private TableDescriptor tableDescriptor;
    private IndexRowGenerator[] indexRowGenerators;
    private long[] indexConglomerateNumbers;
    private String[] indexNames;
    private IndexRowGenerator[] distinctIndexRowGenerators;
    private long[] distinctIndexConglomerateNumbers;
    private String[] distinctIndexNames;

    public IndexLister(TableDescriptor tableDescriptor) {
        this.tableDescriptor = tableDescriptor;
    }

    public IndexRowGenerator[] getIndexRowGenerators() throws StandardException {
        if (this.indexRowGenerators == null) {
            this.getAllIndexes();
        }
        return this.indexRowGenerators;
    }

    public long[] getIndexConglomerateNumbers() throws StandardException {
        if (this.indexConglomerateNumbers == null) {
            this.getAllIndexes();
        }
        return this.indexConglomerateNumbers;
    }

    public String[] getIndexNames() throws StandardException {
        if (this.indexNames == null) {
            this.getAllIndexes();
        }
        return this.indexNames;
    }

    public IndexRowGenerator[] getDistinctIndexRowGenerators() throws StandardException {
        if (this.distinctIndexRowGenerators == null) {
            this.getAllIndexes();
        }
        return this.distinctIndexRowGenerators;
    }

    public long[] getDistinctIndexConglomerateNumbers() throws StandardException {
        if (this.distinctIndexConglomerateNumbers == null) {
            this.getAllIndexes();
        }
        return this.distinctIndexConglomerateNumbers;
    }

    public String[] getDistinctIndexNames() throws StandardException {
        if (this.indexNames == null) {
            this.getAllIndexes();
        }
        return this.indexNames;
    }

    private void getAllIndexes() throws StandardException {
        int indexCount = 0;
        ConglomerateDescriptor[] cds = this.tableDescriptor.getConglomerateDescriptors();
        long[] workSpace = new long[cds.length - 1];
        int distinctIndexCount = 0;
        int duplicateIndex = workSpace.length - 1;
        for (int i = 0; i < cds.length; ++i) {
            int k;
            ConglomerateDescriptor cd = cds[i];
            if (!cd.isIndex()) continue;
            long thisCongNum = cd.getConglomerateNumber();
            for (k = 0; k < distinctIndexCount; ++k) {
                if (workSpace[k] != thisCongNum) continue;
                workSpace[duplicateIndex--] = i;
                break;
            }
            if (k == distinctIndexCount) {
                workSpace[distinctIndexCount++] = thisCongNum;
            }
            ++indexCount;
        }
        this.indexRowGenerators = new IndexRowGenerator[indexCount];
        this.indexConglomerateNumbers = new long[indexCount];
        this.indexNames = new String[indexCount];
        this.distinctIndexRowGenerators = new IndexRowGenerator[distinctIndexCount];
        this.distinctIndexConglomerateNumbers = new long[distinctIndexCount];
        this.distinctIndexNames = new String[distinctIndexCount];
        int duplicatePtr = workSpace.length - 1;
        int j = -1;
        int k = -1;
        for (int i = 0; i < cds.length; ++i) {
            ConglomerateDescriptor cd = cds[i];
            if (!cd.isIndex()) continue;
            this.indexRowGenerators[++j] = cd.getIndexDescriptor();
            this.indexConglomerateNumbers[j] = cd.getConglomerateNumber();
            if (!cd.isConstraint()) {
                this.indexNames[j] = cd.getConglomerateName();
            }
            if (duplicatePtr > duplicateIndex && i == (int)workSpace[duplicatePtr]) {
                --duplicatePtr;
                continue;
            }
            this.distinctIndexRowGenerators[++k] = this.indexRowGenerators[j];
            this.distinctIndexConglomerateNumbers[k] = this.indexConglomerateNumbers[j];
            this.distinctIndexNames[k] = this.indexNames[j];
        }
    }
}

