/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConsInfo;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

public class DDUtils {
    public static ReferencedKeyConstraintDescriptor locateReferencedConstraint(DataDictionary dd, TableDescriptor td, String myConstraintName, String[] myColumnNames, ConsInfo otherConstraintInfo) throws StandardException {
        TableDescriptor refTd = otherConstraintInfo.getReferencedTableDescriptor(dd);
        if (refTd == null) {
            throw StandardException.newException("X0Y46.S", (Object)myConstraintName, (Object)otherConstraintInfo.getReferencedTableName());
        }
        ReferencedKeyConstraintDescriptor refCd = null;
        String[] refColumnNames = otherConstraintInfo.getReferencedColumnNames();
        if (refColumnNames == null || refColumnNames.length == 0) {
            refCd = refTd.getPrimaryKey();
            if (refCd == null) {
                throw StandardException.newException("X0Y41.S", (Object)myConstraintName, (Object)refTd.getQualifiedName());
            }
            ColumnDescriptorList cdl = DDUtils.getColumnDescriptors(dd, td, myColumnNames);
            if (cdl.size() != refCd.getColumnDescriptors().size()) {
                throw StandardException.newException("X0Y43.S", (Object)myConstraintName, (Object)String.valueOf(cdl.size()), (Object)String.valueOf(refCd.getColumnDescriptors().size()));
            }
            if (!refCd.areColumnsComparable(cdl)) {
                throw StandardException.newException("X0Y42.S", myConstraintName);
            }
            return refCd;
        }
        ColumnDescriptorList colDl = DDUtils.getColumnDescriptors(dd, td, myColumnNames);
        ConstraintDescriptorList refCDL = dd.getConstraintDescriptors(refTd);
        int refCDLSize = refCDL.size();
        for (int index = 0; index < refCDLSize; ++index) {
            ConstraintDescriptor cd = refCDL.elementAt(index);
            if (!(cd instanceof ReferencedKeyConstraintDescriptor) || !cd.areColumnsComparable(colDl) || !DDUtils.columnNamesMatch(refColumnNames, cd.getColumnDescriptors())) continue;
            return (ReferencedKeyConstraintDescriptor)cd;
        }
        throw StandardException.newException("X0Y44.S", (Object)myConstraintName, (Object)refTd.getQualifiedName());
    }

    public static ColumnDescriptorList getColumnDescriptors(DataDictionary dd, TableDescriptor td, String[] columnNames) throws StandardException {
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        for (int colCtr = 0; colCtr < columnNames.length; ++colCtr) {
            ColumnDescriptor cd = td.getColumnDescriptor(columnNames[colCtr]);
            cdl.add(td.getUUID(), cd);
        }
        return cdl;
    }

    public static boolean columnNamesMatch(String[] columnNames, ColumnDescriptorList cdl) throws StandardException {
        if (columnNames.length != cdl.size()) {
            return false;
        }
        for (int index = 0; index < columnNames.length; ++index) {
            String name = cdl.elementAt(index).getColumnName();
            if (name.equals(columnNames[index])) continue;
            return false;
        }
        return true;
    }

    public static void validateReferentialActions(DataDictionary dd, TableDescriptor td, String myConstraintName, ConsInfo otherConstraintInfo, String[] columnNames) throws StandardException {
        int refAction = otherConstraintInfo.getReferentialActionDeleteRule();
        if (refAction == 3) {
            boolean foundNullableColumn = false;
            for (int colCtr = 0; colCtr < columnNames.length; ++colCtr) {
                ColumnDescriptor cd = td.getColumnDescriptor(columnNames[colCtr]);
                if (!cd.getType().isNullable()) continue;
                foundNullableColumn = true;
                break;
            }
            if (!foundNullableColumn) {
                throw StandardException.newException("42834", myConstraintName);
            }
        }
        TableDescriptor refTd = otherConstraintInfo.getReferencedTableDescriptor(dd);
        Hashtable deleteConnHashtable = new Hashtable();
        boolean isSelfReferencingFk = refTd.getUUID().equals(td.getUUID());
        String refTableName = refTd.getSchemaName() + "." + refTd.getName();
        int currentSelfRefValue = DDUtils.getCurrentDeleteConnections(dd, td, -1, deleteConnHashtable, false, true);
        DDUtils.validateDeleteConnection(dd, td, refTd, refAction, deleteConnHashtable, (Hashtable)deleteConnHashtable.clone(), true, myConstraintName, false, new StringBuffer(0), refTableName, isSelfReferencingFk, currentSelfRefValue);
        if (!isSelfReferencingFk) {
            DDUtils.checkForAnyExistingDeleteConnectionViolations(dd, td, refAction, deleteConnHashtable, myConstraintName);
        }
    }

    private static int getCurrentDeleteConnections(DataDictionary dd, TableDescriptor td, int refActionType, Hashtable dch, boolean prevNotCascade, boolean findSelfRef) throws StandardException {
        int selfRefValue = -1;
        td.emptyConstraintDescriptorList();
        ConstraintDescriptorList cdl = dd.getConstraintDescriptors(td);
        int cdlSize = cdl.size();
        boolean passedInPrevNotCascade = prevNotCascade;
        for (int index = 0; index < cdlSize; ++index) {
            ConstraintDescriptor cd = cdl.elementAt(index);
            if (!(cd instanceof ForeignKeyConstraintDescriptor)) continue;
            ForeignKeyConstraintDescriptor fkcd = (ForeignKeyConstraintDescriptor)cd;
            String constraintName = fkcd.getConstraintName();
            int raDeleteRule = fkcd.getRaDeleteRule();
            int raUpdateRule = fkcd.getRaUpdateRule();
            if (findSelfRef && fkcd.isSelfReferencingFK()) {
                selfRefValue = raDeleteRule;
                findSelfRef = false;
            }
            ReferencedKeyConstraintDescriptor refcd = fkcd.getReferencedConstraint();
            TableDescriptor refTd = refcd.getTableDescriptor();
            int childRefAction = refActionType == -1 ? raDeleteRule : refActionType;
            String refTableName = refTd.getSchemaName() + "." + refTd.getName();
            Integer rAction = (Integer)dch.get(refTableName);
            if (rAction != null) {
                prevNotCascade = passedInPrevNotCascade;
                continue;
            }
            if (raDeleteRule != 0) {
                if (prevNotCascade) {
                    prevNotCascade = passedInPrevNotCascade;
                    continue;
                }
                prevNotCascade = true;
            }
            dch.put(refTableName, new Integer(childRefAction));
            if (!fkcd.isSelfReferencingFK()) {
                DDUtils.getCurrentDeleteConnections(dd, refTd, childRefAction, dch, true, false);
            }
            prevNotCascade = passedInPrevNotCascade;
        }
        return selfRefValue;
    }

    private static void validateDeleteConnection(DataDictionary dd, TableDescriptor actualTd, TableDescriptor refTd, int refActionType, Hashtable dch, Hashtable ech, boolean checkImmediateRefTable, String myConstraintName, boolean prevNotCascade, StringBuffer cycleString, String currentRefTableName, boolean isSelfReferencingFk, int currentSelfRefValue) throws StandardException {
        Integer rAction;
        String refTableName = refTd.getSchemaName() + "." + refTd.getName();
        if (checkImmediateRefTable) {
            rAction = (Integer)dch.get(refTableName);
            if (isSelfReferencingFk) {
                if (currentSelfRefValue != -1) {
                    if (currentSelfRefValue != refActionType) {
                        if (currentSelfRefValue == 3) {
                            throw DDUtils.generateError("XCL33.S", myConstraintName, currentRefTableName);
                        }
                        throw DDUtils.generateError("XCL36.S", myConstraintName, currentSelfRefValue);
                    }
                    if (currentSelfRefValue == 3 && refActionType == 3) {
                        throw DDUtils.generateError("XCL33.S", myConstraintName, currentRefTableName);
                    }
                }
                if (isSelfReferencingFk && dch.contains(new Integer(0)) && refActionType != 0) {
                    throw DDUtils.generateError("XCL37.S", myConstraintName, 0);
                }
                return;
            }
            if (currentSelfRefValue != -1 && refActionType == 0 && currentSelfRefValue != 0) {
                throw DDUtils.generateError("XCL39.S", myConstraintName);
            }
            if (rAction != null) {
                DDUtils.checkForMultiplePathInvalidCases(rAction, refActionType, myConstraintName, currentRefTableName);
            }
            if (refActionType != 0) {
                prevNotCascade = true;
            }
            cycleString = cycleString.append(refActionType);
        }
        boolean passedInPrevNotCascade = prevNotCascade;
        boolean multiPathCheck = true;
        ConstraintDescriptorList refCDL = dd.getConstraintDescriptors(refTd);
        int refCDLSize = refCDL.size();
        for (int index = 0; index < refCDLSize; ++index) {
            String nextRefTableName;
            ConstraintDescriptor cd = refCDL.elementAt(index);
            if (!(cd instanceof ForeignKeyConstraintDescriptor)) continue;
            ForeignKeyConstraintDescriptor fkcd = (ForeignKeyConstraintDescriptor)cd;
            String constraintName = fkcd.getConstraintName();
            int raDeleteRule = fkcd.getRaDeleteRule();
            int raUpdateRule = fkcd.getRaUpdateRule();
            ReferencedKeyConstraintDescriptor refcd = fkcd.getReferencedConstraint();
            TableDescriptor nextRefTd = refcd.getTableDescriptor();
            if (raDeleteRule != 0) {
                if (prevNotCascade) {
                    prevNotCascade = passedInPrevNotCascade;
                    continue;
                }
                prevNotCascade = true;
                multiPathCheck = false;
            }
            boolean isSelfRefLink = fkcd.isSelfReferencingFK();
            cycleString = cycleString.append(raDeleteRule);
            boolean isFormingCycle = nextRefTd.getUUID().equals(actualTd.getUUID());
            if (isFormingCycle) {
                for (int i = 0; i < cycleString.length(); ++i) {
                    int otherRefAction = Character.getNumericValue(cycleString.charAt(i));
                    if (otherRefAction == refActionType) continue;
                    if (otherRefAction != 0) {
                        throw DDUtils.generateError("XCL40.S", myConstraintName);
                    }
                    throw DDUtils.generateError("XCL34.S", myConstraintName, currentRefTableName);
                }
            }
            if ((rAction = (Integer)ech.get(nextRefTableName = nextRefTd.getSchemaName() + "." + nextRefTd.getName())) != null) {
                if (!isSelfRefLink && multiPathCheck) {
                    DDUtils.checkForMultiplePathInvalidCases(rAction, refActionType, myConstraintName, currentRefTableName);
                }
            } else {
                rAction = (Integer)dch.get(nextRefTableName);
                if (rAction == null) {
                    if (multiPathCheck) {
                        dch.put(nextRefTableName, new Integer(refActionType));
                    }
                    if (!isSelfRefLink) {
                        DDUtils.validateDeleteConnection(dd, actualTd, nextRefTd, refActionType, dch, ech, false, myConstraintName, prevNotCascade, cycleString, currentRefTableName, isSelfReferencingFk, currentSelfRefValue);
                    }
                }
            }
            prevNotCascade = passedInPrevNotCascade;
            cycleString.setLength(cycleString.length() - 1);
        }
    }

    private static void checkForMultiplePathInvalidCases(int currentRefAction, int refActionType, String myConstraintName, String currentRefTableName) throws StandardException {
        if (currentRefAction != refActionType) {
            if (currentRefAction == 3) {
                throw DDUtils.generateError("XCL35.S", myConstraintName, currentRefTableName);
            }
            throw DDUtils.generateError("XCL38.S", myConstraintName, currentRefAction);
        }
        if (currentRefAction == 3 && refActionType == 3) {
            throw DDUtils.generateError("XCL35.S", myConstraintName, currentRefTableName);
        }
    }

    private static void checkForAnyExistingDeleteConnectionViolations(DataDictionary dd, TableDescriptor td, int refActionType, Hashtable newDconnHashTable, String myConstraintName) throws StandardException {
        if (refActionType != 0) {
            return;
        }
        String addTableName = td.getSchemaName() + "." + td.getName();
        ConstraintDescriptorList refCDL = dd.getConstraintDescriptors(td);
        int refCDLSize = refCDL.size();
        for (int index = 0; index < refCDLSize; ++index) {
            ConstraintDescriptorList fkcdl;
            int size;
            ConstraintDescriptor cd = refCDL.elementAt(index);
            if (!(cd instanceof ReferencedKeyConstraintDescriptor) || (size = (fkcdl = dd.getActiveConstraintDescriptors(((ReferencedKeyConstraintDescriptor)cd).getForeignKeyConstraints(3))).size()) == 0) continue;
            Hashtable dConnHashtable = new Hashtable();
            for (int inner = 0; inner < size; ++inner) {
                ForeignKeyConstraintDescriptor fkcd = (ForeignKeyConstraintDescriptor)fkcdl.elementAt(inner);
                TableDescriptor fktd = fkcd.getTableDescriptor();
                int raDeleteRuleToAddTable = fkcd.getRaDeleteRule();
                if (!fkcd.isSelfReferencingFK()) {
                    DDUtils.getCurrentDeleteConnections(dd, fktd, -1, dConnHashtable, false, true);
                    Enumeration e = dConnHashtable.keys();
                    while (e.hasMoreElements()) {
                        int currentDeleteRule;
                        String tName = (String)e.nextElement();
                        if (tName.equals(addTableName) || !newDconnHashTable.containsKey(tName) || ((currentDeleteRule = ((Integer)dConnHashtable.get(tName)).intValue()) != 3 || raDeleteRuleToAddTable != 3) && currentDeleteRule == raDeleteRuleToAddTable) continue;
                        throw DDUtils.generateError("XCL41.S", myConstraintName);
                    }
                }
                dConnHashtable.clear();
            }
        }
    }

    private static StandardException generateError(String messageId, String myConstraintName) {
        String message = MessageService.getTextMessage(messageId);
        return StandardException.newException("42915", (Object)myConstraintName, (Object)message);
    }

    private static StandardException generateError(String messageId, String myConstraintName, int raRule) {
        String raRuleStringId;
        switch (raRule) {
            case 0: {
                raRuleStringId = "XCL42.S";
                break;
            }
            case 1: {
                raRuleStringId = "XCL44.S";
                break;
            }
            case 2: {
                raRuleStringId = "XCL45.S";
                break;
            }
            case 3: {
                raRuleStringId = "XCL43.S";
                break;
            }
            case 4: {
                raRuleStringId = "XCL46.S";
                break;
            }
            default: {
                raRuleStringId = "XCL45.S";
            }
        }
        String raRuleMessageString = MessageService.getTextMessage(raRuleStringId);
        String message = MessageService.getTextMessage(messageId, raRuleMessageString);
        return StandardException.newException("42915", (Object)myConstraintName, (Object)message);
    }

    private static StandardException generateError(String messageId, String myConstraintName, String refTableName) {
        String message = MessageService.getTextMessage(messageId, refTableName);
        return StandardException.newException("42915", (Object)myConstraintName, (Object)message);
    }
}

