/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.monitor;

import java.io.PrintStream;
import java.util.Locale;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.services.loader.InstanceGetter;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.impl.services.monitor.FileMonitor;

public class Monitor {
    public static final String SERVICE_TYPE_DIRECTORY = "serviceDirectory";
    public static final Object syncMe = new Object();
    public static final String NEW_INSTANCE_FROM_ID_TRACE_DEBUG_FLAG = "MonitorNewInstanceFromId";
    public static final String DEBUG_TRUE = "derby.debug.true";
    public static final String DEBUG_FALSE = "derby.debug.false";
    private static ModuleFactory monitor;
    private static boolean active;

    public static void startMonitor(Properties bootProperties, PrintStream logging) {
        new FileMonitor(bootProperties, logging);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setMonitor(ModuleFactory theMonitor) {
        Object object = syncMe;
        synchronized (object) {
            if (active) {
                return false;
            }
            monitor = theMonitor;
            active = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearMonitor() {
        Object object = syncMe;
        synchronized (object) {
            active = false;
        }
    }

    public static ModuleFactory getMonitor() {
        return monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleFactory getMonitorLite() {
        Object object = syncMe;
        synchronized (object) {
            if (active && monitor != null) {
                return monitor;
            }
        }
        return new FileMonitor();
    }

    public static HeaderPrintWriter getStream() {
        return monitor.getSystemStreams().stream();
    }

    public static String getServiceName(Object serviceModule) {
        return monitor.getServiceName(serviceModule);
    }

    public static Object startSystemModule(String factoryInterface) throws StandardException {
        Object module = monitor.startModule(false, null, factoryInterface, null, null);
        SanityManager.ASSERT(module != null, "module is null - " + factoryInterface);
        return module;
    }

    public static Object findSystemModule(String factoryInterface) throws StandardException {
        Object module = Monitor.getMonitor().findModule(null, factoryInterface, null);
        if (module == null) {
            throw Monitor.missingImplementation(factoryInterface);
        }
        return module;
    }

    public static Object getSystemModule(String factoryInterface) {
        Object module = Monitor.getMonitor().findModule(null, factoryInterface, null);
        return module;
    }

    public static Object bootServiceModule(boolean create, Object serviceModule, String factoryInterface, Properties properties) throws StandardException {
        Object module = monitor.startModule(create, serviceModule, factoryInterface, null, properties);
        SanityManager.ASSERT(module != null, "module is null - " + factoryInterface);
        return module;
    }

    public static Object bootServiceModule(boolean create, Object serviceModule, String factoryInterface, String identifier, Properties properties) throws StandardException {
        Object module = monitor.startModule(create, serviceModule, factoryInterface, identifier, properties);
        SanityManager.ASSERT(module != null, "module is null - " + factoryInterface);
        return module;
    }

    public static Object findServiceModule(Object serviceModule, String factoryInterface) throws StandardException {
        Object module = Monitor.getMonitor().findModule(serviceModule, factoryInterface, null);
        if (module == null) {
            throw Monitor.missingImplementation(factoryInterface);
        }
        return module;
    }

    public static Object getServiceModule(Object serviceModule, String factoryInterface) {
        Object module = Monitor.getMonitor().findModule(serviceModule, factoryInterface, null);
        return module;
    }

    public static Object findService(String factoryInterface, String serviceName) {
        return monitor.findService(factoryInterface, serviceName);
    }

    public static boolean startPersistentService(String serviceName, Properties properties) throws StandardException {
        SanityManager.ASSERT(serviceName != null, "serviceName is null");
        return monitor.startPersistentService(serviceName, properties);
    }

    public static Object startNonPersistentService(String factoryInterface, String serviceName, Properties properties) throws StandardException {
        SanityManager.ASSERT(factoryInterface != null, "serviceName is null");
        SanityManager.ASSERT(serviceName != null, "serviceName is null");
        return monitor.startNonPersistentService(factoryInterface, serviceName, properties);
    }

    public static Object createPersistentService(String factoryInterface, String serviceName, Properties properties) throws StandardException {
        SanityManager.ASSERT(factoryInterface != null, "serviceName is null");
        SanityManager.ASSERT(serviceName != null, "serviceName is null");
        return monitor.createPersistentService(factoryInterface, serviceName, properties);
    }

    public static void removePersistentService(String name) throws StandardException {
        monitor.removePersistentService(name);
    }

    public static InstanceGetter classFromIdentifier(int identifier) throws StandardException {
        return monitor.classFromIdentifier(identifier);
    }

    public static Object newInstanceFromIdentifier(int identifier) throws StandardException {
        return monitor.newInstanceFromIdentifier(identifier);
    }

    public static StandardException missingProductVersion(String productGenusName) {
        return StandardException.newException("XBM05.D", productGenusName);
    }

    public static StandardException missingImplementation(String implementation) {
        return StandardException.newException("XBM02.D", implementation);
    }

    public static StandardException exceptionStartingModule(Throwable t) {
        return StandardException.newException("XBM01.D", t);
    }

    public static void logMessage(String messageText) {
        Monitor.getStream().println(messageText);
    }

    public static void logTextMessage(String messageID) {
        Monitor.getStream().println(MessageService.getTextMessage(messageID));
    }

    public static void logTextMessage(String messageID, Object a1) {
        Monitor.getStream().println(MessageService.getTextMessage(messageID, a1));
    }

    public static void logTextMessage(String messageID, Object a1, Object a2) {
        Monitor.getStream().println(MessageService.getTextMessage(messageID, a1, a2));
    }

    public static void logTextMessage(String messageID, Object a1, Object a2, Object a3) {
        Monitor.getStream().println(MessageService.getTextMessage(messageID, a1, a2, a3));
    }

    public static void logTextMessage(String messageID, Object a1, Object a2, Object a3, Object a4) {
        Monitor.getStream().println(MessageService.getTextMessage(messageID, a1, a2, a3, a4));
    }

    public static Locale getLocaleFromString(String localeDescription) throws StandardException {
        return monitor.getLocaleFromString(localeDescription);
    }

    public static boolean isFullUpgrade(Properties startParams, String oldVersionInfo) throws StandardException {
        boolean fullUpgrade = Boolean.valueOf(startParams.getProperty("upgrade"));
        ProductVersionHolder engineVersion = Monitor.getMonitor().getEngineVersion();
        if ((engineVersion.isBeta() || engineVersion.isAlpha()) && !PropertyUtil.getSystemBoolean("derby.database.allowPreReleaseUpgrade")) {
            throw StandardException.newException("XCW00.D", (Object)oldVersionInfo, (Object)engineVersion.getSimpleVersionString());
        }
        return fullUpgrade;
    }

    public static boolean isDesiredType(Properties startParams, int desiredProperty) {
        int engineType = 2;
        if (startParams != null) {
            engineType = Monitor.getEngineType(startParams);
        }
        return (engineType & desiredProperty) != 0;
    }

    public static boolean isDesiredType(int engineType, int desiredType) {
        return (engineType & desiredType) != 0;
    }

    public static int getEngineType(Properties startParams) {
        if (startParams != null) {
            String etp = startParams.getProperty("derby.engineType");
            int engineType = etp == null ? 2 : Integer.parseInt(etp.trim());
            return engineType;
        }
        return 2;
    }

    public static boolean isDesiredCreateType(Properties p, int type) {
        boolean plainCreate = Boolean.valueOf(p.getProperty("create"));
        if (plainCreate) {
            return (type & 2) != 0;
        }
        return Monitor.isDesiredType(p, type);
    }

    public static void logThrowable(Throwable t) {
        t.printStackTrace(Monitor.getStream().getPrintWriter());
    }
}

