/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.locks;

import java.util.Hashtable;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.iapi.services.locks.ShExQual;
import org.apache.derby.iapi.services.sanity.SanityManager;

public class ShExLockable
implements Lockable {
    public boolean lockerAlwaysCompatible() {
        return true;
    }

    public boolean requestCompatible(Object requestedQualifier, Object grantedQualifier) {
        if (!(requestedQualifier instanceof ShExQual)) {
            SanityManager.THROWASSERT("requestedQualifier is a " + requestedQualifier.getClass().getName() + "instead of a ShExQual.");
        }
        if (!(grantedQualifier instanceof ShExQual)) {
            SanityManager.THROWASSERT("grantedQualifier is a " + grantedQualifier.getClass().getName() + "instead of a ShExQual.");
        }
        ShExQual requested = (ShExQual)requestedQualifier;
        ShExQual granted = (ShExQual)grantedQualifier;
        return requested.getLockState() == 0 && granted.getLockState() == 0;
    }

    public void lockEvent(Latch lockInfo) {
        if (!(lockInfo.getQualifier() instanceof ShExQual)) {
            SanityManager.THROWASSERT("qualifier is a " + lockInfo.getQualifier().getClass().getName() + "instead of a ShExQual.");
        }
    }

    public void unlockEvent(Latch lockInfo) {
        if (!(lockInfo.getQualifier() instanceof ShExQual)) {
            SanityManager.THROWASSERT("qualifier is a " + lockInfo.getQualifier().getClass().getName() + "instead of a ShExQual.");
        }
    }

    public boolean lockAttributes(int flag, Hashtable attributes) {
        if ((flag & 4) == 0) {
            return false;
        }
        attributes.put("CONTAINERID", new Long(-1L));
        attributes.put("LOCKNAME", this.toString());
        attributes.put("TYPE", "ShExLockable");
        return true;
    }
}

