/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.services.io.Limit;

public class LimitInputStream
extends FilterInputStream
implements Limit {
    protected int remainingBytes;
    protected boolean limitInPlace;

    public LimitInputStream(InputStream in) {
        super(in);
        this.clearLimit();
    }

    public int read() throws IOException {
        if (!this.limitInPlace) {
            return super.read();
        }
        if (this.remainingBytes == 0) {
            return -1;
        }
        int value = super.read();
        if (value >= 0) {
            --this.remainingBytes;
        }
        return value;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.limitInPlace) {
            return super.read(b, off, len);
        }
        if (this.remainingBytes == 0) {
            return -1;
        }
        if (this.remainingBytes < len) {
            len = this.remainingBytes;
        }
        if ((len = super.read(b, off, len)) > 0) {
            this.remainingBytes -= len;
        }
        return len;
    }

    public long skip(long count) throws IOException {
        if (!this.limitInPlace) {
            return super.skip(count);
        }
        if (this.remainingBytes == 0) {
            return 0L;
        }
        if ((long)this.remainingBytes < count) {
            count = this.remainingBytes;
        }
        count = super.skip(count);
        this.remainingBytes = (int)((long)this.remainingBytes - count);
        return count;
    }

    public int available() throws IOException {
        if (!this.limitInPlace) {
            return super.available();
        }
        if (this.remainingBytes == 0) {
            return 0;
        }
        int actualLeft = super.available();
        if (this.remainingBytes < actualLeft) {
            return this.remainingBytes;
        }
        return actualLeft;
    }

    public void setLimit(int length) {
        this.remainingBytes = length;
        this.limitInPlace = true;
    }

    public int clearLimit() {
        int leftOver = this.remainingBytes;
        this.limitInPlace = false;
        this.remainingBytes = -1;
        return leftOver;
    }

    public void setInput(InputStream in) {
        this.in = in;
    }
}

