/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class InputStreamUtil {
    public static int readUnsignedByte(InputStream in) throws IOException {
        int b = in.read();
        if (b < 0) {
            throw new EOFException();
        }
        return b;
    }

    public static void readFully(InputStream in, byte[] b, int offset, int len) throws IOException {
        int bytesRead;
        do {
            if ((bytesRead = in.read(b, offset, len)) < 0) {
                throw new EOFException();
            }
            offset += bytesRead;
        } while ((len -= bytesRead) != 0);
    }

    public static int readLoop(InputStream in, byte[] b, int offset, int len) throws IOException {
        int bytesRead;
        int firstOffset = offset;
        while ((bytesRead = in.read(b, offset, len)) > 0) {
            offset += bytesRead;
            if ((len -= bytesRead) != 0) continue;
        }
        return offset - firstOffset;
    }

    public static long skipBytes(InputStream in, long n) throws IOException {
        while (n > 0L) {
            long delta = in.skip(n);
            if (delta < 0L) {
                throw new EOFException();
            }
            n -= delta;
        }
        return n;
    }
}

