/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import org.apache.derby.iapi.services.io.ErrorObjectInput;
import org.apache.derby.iapi.services.io.FormatIdInputStream;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.util.ReuseFactory;

public final class ArrayInputStream
extends InputStream
implements LimitObjectInput {
    private byte[] pageData;
    private int start;
    private int end;
    private int position;
    private ErrorObjectInput oi;

    public ArrayInputStream() {
        this(ReuseFactory.getZeroLenByteArray());
    }

    public ArrayInputStream(byte[] data) {
        this.setData(data);
        this.oi = new FormatIdInputStream(this);
    }

    public void setData(byte[] data) {
        this.pageData = data;
        this.position = 0;
        this.start = 0;
        this.end = data.length;
    }

    public byte[] getData() {
        return this.pageData;
    }

    public int read() throws IOException {
        if (this.position == this.end) {
            return -1;
        }
        return this.pageData[this.position++] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.position + len > this.end && (len = this.end - this.position) == 0) {
            return -1;
        }
        System.arraycopy(this.pageData, this.position, b, off, len);
        this.position += len;
        return len;
    }

    public long skip(long count) throws IOException {
        if ((long)this.position + count > (long)this.end && (count = (long)(this.end - this.position)) == 0L) {
            return 0L;
        }
        this.position = (int)((long)this.position + count);
        return count;
    }

    public int getPosition() {
        return this.position;
    }

    public final void setPosition(int newPosition) throws IOException {
        if (newPosition < this.start || newPosition >= this.end) {
            throw new EOFException();
        }
        this.position = newPosition;
    }

    public int available() throws IOException {
        return this.end - this.position;
    }

    public void setLimit(int offset, int length) throws IOException {
        this.start = offset;
        this.end = offset + length;
        this.position = this.start;
        if (offset < 0 || length < 0 || this.end > this.pageData.length) {
            this.position = 0;
            this.end = 0;
            this.start = 0;
            throw new EOFException();
        }
    }

    public final void setLimit(int length) throws IOException {
        this.start = this.position;
        this.end = this.position + length;
        if (this.end > this.pageData.length) {
            this.position = 0;
            this.end = 0;
            this.start = 0;
            throw new EOFException();
        }
    }

    public final int clearLimit() {
        this.start = 0;
        int remainingBytes = this.end - this.position;
        this.end = this.pageData.length;
        return remainingBytes;
    }

    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        if (this.position + len > this.end) {
            throw new EOFException();
        }
        System.arraycopy(this.pageData, this.position, b, off, len);
        this.position += len;
    }

    public final int skipBytes(int n) throws IOException {
        if (this.position + n > this.end) {
            throw new EOFException();
        }
        this.position += n;
        return n;
    }

    public final boolean readBoolean() throws IOException {
        if (this.position == this.end) {
            throw new EOFException();
        }
        return this.pageData[this.position++] != 0;
    }

    public final byte readByte() throws IOException {
        if (this.position == this.end) {
            throw new EOFException();
        }
        return this.pageData[this.position++];
    }

    public final int readUnsignedByte() throws IOException {
        if (this.position == this.end) {
            throw new EOFException();
        }
        return this.pageData[this.position++] & 0xFF;
    }

    public final short readShort() throws IOException {
        int pos = this.position;
        byte[] data = this.pageData;
        if (pos >= this.end - 1) {
            throw new EOFException();
        }
        int s = (data[pos++] & 0xFF) << 8 | data[pos++] & 0xFF;
        this.position = pos;
        return (short)s;
    }

    public final int readUnsignedShort() throws IOException {
        int pos = this.position;
        byte[] data = this.pageData;
        if (pos >= this.end - 1) {
            throw new EOFException();
        }
        int us = (data[pos++] & 0xFF) << 8 | data[pos++] & 0xFF;
        this.position = pos;
        return us;
    }

    public final char readChar() throws IOException {
        int pos = this.position;
        byte[] data = this.pageData;
        if (pos >= this.end - 1) {
            throw new EOFException();
        }
        int c = (data[pos++] & 0xFF) << 8 | data[pos++] & 0xFF;
        this.position = pos;
        return (char)c;
    }

    public final int readInt() throws IOException {
        int pos = this.position;
        byte[] data = this.pageData;
        if (pos >= this.end - 3) {
            throw new EOFException();
        }
        int i = (data[pos++] & 0xFF) << 24 | (data[pos++] & 0xFF) << 16 | (data[pos++] & 0xFF) << 8 | data[pos++] & 0xFF;
        this.position = pos;
        return i;
    }

    public final long readLong() throws IOException {
        int pos = this.position;
        byte[] data = this.pageData;
        if (pos >= this.end - 7) {
            throw new EOFException();
        }
        long l = (long)(data[pos++] & 0xFF) << 56 | (long)(data[pos++] & 0xFF) << 48 | (long)(data[pos++] & 0xFF) << 40 | (long)(data[pos++] & 0xFF) << 32 | (long)(data[pos++] & 0xFF) << 24 | (long)(data[pos++] & 0xFF) << 16 | (long)(data[pos++] & 0xFF) << 8 | (long)(data[pos++] & 0xFF);
        this.position = pos;
        return l;
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readLine() throws IOException {
        return this.oi.readLine();
    }

    public final String readUTF() throws IOException {
        return this.oi.readUTF();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int readDerbyUTF(char[][] rawData_array) throws IOException {
        int requiredLength;
        byte[] data = this.pageData;
        int pos = this.position;
        int end_pos = this.end;
        if (pos + 1 >= end_pos) {
            throw new EOFException();
        }
        int utflen = (data[pos++] & 0xFF) << 8 | data[pos++] & 0xFF;
        if (utflen != 0) {
            if (utflen > end_pos - pos) throw new EOFException();
            requiredLength = utflen;
        } else {
            requiredLength = end_pos - pos;
        }
        char[] str = rawData_array[0];
        if (str == null || requiredLength > str.length) {
            str = new char[requiredLength];
            rawData_array[0] = str;
        }
        end_pos = pos + requiredLength;
        int strlen = 0;
        while (pos < end_pos) {
            int char2;
            int char1;
            if (((char1 = data[pos++] & 0xFF) & 0x80) == 0) {
                str[strlen++] = (char)char1;
                continue;
            }
            if ((char1 & 0x60) == 64) {
                if (pos >= end_pos) {
                    throw new UTFDataFormatException();
                }
                if (((char2 = data[pos++] & 0xFF) & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                str[strlen++] = (char)((char1 & 0x1F) << 6 | char2 & 0x3F);
                continue;
            }
            if ((char1 & 0x70) != 96) throw new UTFDataFormatException();
            if (pos + 1 >= end_pos) {
                throw new UTFDataFormatException();
            }
            char2 = data[pos++] & 0xFF;
            int char3 = data[pos++] & 0xFF;
            if (char1 == 224 && char2 == 0 && char3 == 0 && utflen == 0) break;
            if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                throw new UTFDataFormatException();
            }
            str[strlen++] = (char)((char1 & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
        }
        this.position = pos;
        return strlen;
    }

    public final int readCompressedInt() throws IOException {
        int pos = this.position;
        byte[] data = this.pageData;
        try {
            int value = data[pos++];
            if ((value & 0xFFFFFFC0) != 0) {
                if ((value & 0x80) == 0) {
                    SanityManager.ASSERT((value & 0x40) == 64);
                    value = (value & 0x3F) << 8 | data[pos++] & 0xFF;
                } else {
                    SanityManager.ASSERT((value & 0x80) == 128);
                    value = (value & 0x7F) << 24 | (data[pos++] & 0xFF) << 16 | (data[pos++] & 0xFF) << 8 | data[pos++] & 0xFF;
                }
            }
            this.position = pos;
            return value;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new EOFException();
        }
    }

    public final long readCompressedLong() throws IOException {
        try {
            int pos = this.position;
            byte[] data = this.pageData;
            byte int_value = data[pos++];
            long long_value = (int_value & 0xFFFFFFC0) == 0 ? (long)(int_value << 8 | data[pos++] & 0xFF) : ((int_value & 0x80) == 0 ? (long)((int_value & 0x3F) << 24 | (data[pos++] & 0xFF) << 16 | (data[pos++] & 0xFF) << 8 | data[pos++] & 0xFF) : (long)(int_value & 0x7F) << 56 | (long)(data[pos++] & 0xFF) << 48 | (long)(data[pos++] & 0xFF) << 40 | (long)(data[pos++] & 0xFF) << 32 | (long)(data[pos++] & 0xFF) << 24 | (long)(data[pos++] & 0xFF) << 16 | (long)(data[pos++] & 0xFF) << 8 | (long)(data[pos++] & 0xFF));
            this.position = pos;
            return long_value;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new EOFException();
        }
    }

    public Object readObject() throws ClassNotFoundException, IOException {
        return this.oi.readObject();
    }

    public String getErrorInfo() {
        return this.oi.getErrorInfo();
    }

    public Exception getNestedException() {
        return this.oi.getNestedException();
    }
}

