/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.derby.iapi.services.context.ShutdownException;
import org.apache.derby.iapi.services.i18n.BundleFinder;

public final class MessageService {
    private static final Locale EN = new Locale("en", "US");
    private static BundleFinder finder;

    private MessageService() {
    }

    public static ResourceBundle getBundleForLocale(Locale locale, String msgId) {
        try {
            return MessageService.getBundleWithEnDefault("org.apache.derby.loc.m" + MessageService.hashString50(msgId), locale);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static Object setFinder(BundleFinder theFinder) {
        finder = theFinder;
        return new MessageService().getClass();
    }

    public static String getTextMessage(String messageID) {
        return MessageService.getCompleteMessage(messageID, null);
    }

    public static String getTextMessage(String messageID, Object a1) {
        return MessageService.getCompleteMessage(messageID, new Object[]{a1});
    }

    public static String getTextMessage(String messageID, Object a1, Object a2) {
        return MessageService.getCompleteMessage(messageID, new Object[]{a1, a2});
    }

    public static String getTextMessage(String messageID, Object a1, Object a2, Object a3) {
        return MessageService.getCompleteMessage(messageID, new Object[]{a1, a2, a3});
    }

    public static String getTextMessage(String messageID, Object a1, Object a2, Object a3, Object a4) {
        return MessageService.getCompleteMessage(messageID, new Object[]{a1, a2, a3, a4});
    }

    public static String getCompleteMessage(String messageId, Object[] arguments) {
        try {
            return MessageService.formatMessage(MessageService.getBundle(messageId), messageId, arguments, true);
        }
        catch (MissingResourceException mre) {
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        return MessageService.formatMessage(MessageService.getBundleForLocale(EN, messageId), messageId, arguments, false);
    }

    public static void getLocalizedMessage(int sqlcode, short errmcLen, String sqlerrmc, String sqlerrp, int errd0, int errd1, int errd2, int errd3, int errd4, int errd5, String warn, String sqlState, String file, String localeStr, String[] msg, int[] rc) {
        int _pos1 = localeStr.indexOf("_");
        int _pos2 = localeStr.lastIndexOf("_");
        Locale locale = EN;
        if (_pos1 != -1) {
            String country;
            String language = localeStr.substring(0, _pos1);
            if (_pos2 == _pos1) {
                country = localeStr.substring(_pos1 + 1);
                locale = new Locale(language, country);
            } else {
                country = localeStr.substring(_pos1 + 1, _pos2);
                String variant = localeStr.substring(_pos2 + 1);
                locale = new Locale(language, country, variant);
            }
        }
        String messageId = sqlState;
        Object[] arguments = null;
        if (sqlerrmc != null && sqlerrmc.length() > 0) {
            char[] sqlerrmc_chars = sqlerrmc.toCharArray();
            int numArgs = 0;
            int lastSepIdx = -1;
            for (int i = 0; i < sqlerrmc_chars.length; ++i) {
                if (sqlerrmc_chars[i] != '\u0014') continue;
                ++numArgs;
                lastSepIdx = i;
            }
            if (numArgs == 0) {
                messageId = new String(sqlerrmc_chars);
            } else {
                messageId = new String(sqlerrmc_chars, lastSepIdx + 1, sqlerrmc_chars.length - lastSepIdx - 1);
                arguments = new Object[numArgs];
                int start = 0;
                int arg = 0;
                for (int i = 0; i < lastSepIdx + 1; ++i) {
                    if (i != lastSepIdx && sqlerrmc_chars[i] != '\u0014') continue;
                    arguments[arg++] = new String(sqlerrmc_chars, start, i - start);
                    start = i + 1;
                }
            }
        }
        try {
            msg[0] = MessageService.formatMessage(MessageService.getBundleForLocale(locale, messageId), messageId, arguments, true);
            rc[0] = 0;
            return;
        }
        catch (MissingResourceException mre) {
        }
        catch (ShutdownException se) {
            // empty catch block
        }
        msg[0] = MessageService.formatMessage(MessageService.getBundleForLocale(EN, messageId), messageId, arguments, false);
        rc[0] = 0;
    }

    public static String getLocalizedMessage(Locale locale, String messageId, Object[] args) {
        String locMsg = null;
        try {
            locMsg = MessageService.formatMessage(MessageService.getBundleForLocale(locale, messageId), messageId, args, true);
            return locMsg;
        }
        catch (MissingResourceException mre) {
        }
        catch (ShutdownException se) {
            // empty catch block
        }
        locMsg = MessageService.formatMessage(MessageService.getBundleForLocale(EN, messageId), messageId, args, false);
        return locMsg;
    }

    public static String getProperty(String messageId, String propertyName) {
        ResourceBundle bundle = MessageService.getBundle(messageId);
        try {
            if (bundle != null) {
                return bundle.getString(messageId.concat(".").concat(propertyName));
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return null;
    }

    public static String formatMessage(ResourceBundle bundle, String messageId, Object[] arguments, boolean lastChance) {
        block11: {
            if (arguments == null) {
                arguments = new Object[]{};
            }
            if (bundle != null) {
                try {
                    messageId = bundle.getString(messageId);
                    try {
                        return MessageFormat.format(messageId, arguments);
                    }
                    catch (IllegalArgumentException iae) {
                    }
                    catch (NullPointerException npe) {
                    }
                }
                catch (MissingResourceException mre) {
                    if (!lastChance) break block11;
                    throw mre;
                }
            }
        }
        if (messageId == null) {
            messageId = "UNKNOWN";
        }
        StringBuffer sb = new StringBuffer(messageId);
        sb.append(" : ");
        int len = arguments.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append('[');
            sb.append(i);
            sb.append("] ");
            if (arguments[i] == null) {
                sb.append("null");
                continue;
            }
            sb.append(arguments[i].toString());
        }
        return sb.toString();
    }

    private static ResourceBundle getBundle(String messageId) {
        ResourceBundle bundle = null;
        if (finder != null) {
            bundle = finder.getBundle(messageId);
        }
        if (bundle == null) {
            bundle = MessageService.getBundleForLocale(Locale.getDefault(), messageId);
        }
        return bundle;
    }

    public static ResourceBundle getBundleWithEnDefault(String resource, Locale locale) {
        try {
            return ResourceBundle.getBundle(resource, locale);
        }
        catch (MissingResourceException mre) {
            return ResourceBundle.getBundle(resource, EN);
        }
    }

    public static int hashString50(String key) {
        int hash = 0;
        int len = key.length();
        if (len > 5) {
            len = 5;
        }
        for (int i = 0; i < len; ++i) {
            hash += key.charAt(i);
        }
        return hash %= 50;
    }
}

