/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.BrokeredCallableStatement;
import org.apache.derby.iapi.jdbc.BrokeredConnectionControl;
import org.apache.derby.iapi.jdbc.BrokeredPreparedStatement;
import org.apache.derby.iapi.jdbc.BrokeredStatement;
import org.apache.derby.iapi.jdbc.BrokeredStatementControl;
import org.apache.derby.iapi.jdbc.EngineConnection;
import org.apache.derby.impl.jdbc.EmbedSQLWarning;
import org.apache.derby.impl.jdbc.Util;

public abstract class BrokeredConnection
implements EngineConnection {
    int stateHoldability = 1;
    final BrokeredConnectionControl control;
    private boolean isClosed;
    private String connString;
    private int stateIsolationLevel;
    private boolean stateReadOnly;
    private boolean stateAutoCommit;

    public BrokeredConnection(BrokeredConnectionControl control) {
        this.control = control;
    }

    public final void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this.control.checkAutoCommit(autoCommit);
            this.getRealConnection().setAutoCommit(autoCommit);
            this.stateAutoCommit = autoCommit;
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public final boolean getAutoCommit() throws SQLException {
        try {
            return this.getRealConnection().getAutoCommit();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public final Statement createStatement() throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().createStatement());
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(sql), sql, null);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public final CallableStatement prepareCall(String sql) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareCall(sql), sql);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public final String nativeSQL(String sql) throws SQLException {
        try {
            return this.getRealConnection().nativeSQL(sql);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public final void commit() throws SQLException {
        try {
            this.control.checkCommit();
            this.getRealConnection().commit();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public final void rollback() throws SQLException {
        try {
            this.control.checkRollback();
            this.getRealConnection().rollback();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public final void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        try {
            if (!this.control.closingConnection()) {
                this.isClosed = true;
                return;
            }
            this.isClosed = true;
            this.getRealConnection().close();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public final boolean isClosed() throws SQLException {
        if (this.isClosed) {
            return true;
        }
        try {
            boolean realIsClosed = this.getRealConnection().isClosed();
            if (realIsClosed) {
                this.control.closingConnection();
                this.isClosed = true;
            }
            return realIsClosed;
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public final SQLWarning getWarnings() throws SQLException {
        try {
            return this.getRealConnection().getWarnings();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public final void clearWarnings() throws SQLException {
        try {
            this.getRealConnection().clearWarnings();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public final DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.getRealConnection().getMetaData();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public final void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this.getRealConnection().setReadOnly(readOnly);
            this.stateReadOnly = readOnly;
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public final boolean isReadOnly() throws SQLException {
        try {
            return this.getRealConnection().isReadOnly();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public final void setCatalog(String catalog) throws SQLException {
        try {
            this.getRealConnection().setCatalog(catalog);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public final String getCatalog() throws SQLException {
        try {
            return this.getRealConnection().getCatalog();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public final void setTransactionIsolation(int level) throws SQLException {
        try {
            this.getRealConnection().setTransactionIsolation(level);
            this.stateIsolationLevel = level;
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public final int getTransactionIsolation() throws SQLException {
        try {
            return this.getRealConnection().getTransactionIsolation();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public final Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().createStatement(resultSetType, resultSetConcurrency));
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(sql, resultSetType, resultSetConcurrency), sql, null);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareCall(sql, resultSetType, resultSetConcurrency), sql);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            return this.getRealConnection().getTypeMap();
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    public final void setTypeMap(Map map) throws SQLException {
        try {
            this.getRealConnection().setTypeMap(map);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    final EngineConnection getRealConnection() throws SQLException {
        if (this.isClosed) {
            throw Util.noCurrentConnection();
        }
        return this.control.getRealConnection();
    }

    final void notifyException(SQLException sqle) {
        if (!this.isClosed) {
            this.control.notifyException(sqle);
        }
    }

    public void syncState() throws SQLException {
        EngineConnection conn = this.getRealConnection();
        this.stateIsolationLevel = conn.getTransactionIsolation();
        this.stateReadOnly = conn.isReadOnly();
        this.stateAutoCommit = conn.getAutoCommit();
        this.stateHoldability = conn.getHoldability();
    }

    public void getIsolationUptoDate() throws SQLException {
        if (this.control.isIsolationLevelSetUsingSQLorJDBC()) {
            this.stateIsolationLevel = this.getRealConnection().getTransactionIsolation();
            this.control.resetIsolationLevelFlag();
        }
    }

    public void setState(boolean complete) throws SQLException {
        Class[] CONN_PARAM = new Class[]{Integer.TYPE};
        Object[] CONN_ARG = new Object[]{new Integer(this.stateHoldability)};
        EngineConnection conn = this.getRealConnection();
        if (complete) {
            conn.setTransactionIsolation(this.stateIsolationLevel);
            conn.setReadOnly(this.stateReadOnly);
            conn.setAutoCommit(this.stateAutoCommit);
            try {
                Method sh = conn.getClass().getMethod("setHoldability", CONN_PARAM);
                sh.invoke((Object)conn, CONN_ARG);
            }
            catch (Exception e) {
                throw PublicAPI.wrapStandardException(StandardException.plainWrapException(e));
            }
        }
    }

    public BrokeredStatement newBrokeredStatement(BrokeredStatementControl statementControl) throws SQLException {
        return new BrokeredStatement(statementControl, this.getJDBCLevel());
    }

    public abstract BrokeredPreparedStatement newBrokeredStatement(BrokeredStatementControl var1, String var2, Object var3) throws SQLException;

    public abstract BrokeredCallableStatement newBrokeredStatement(BrokeredStatementControl var1, String var2) throws SQLException;

    public final void setDrdaID(String drdaID) {
        try {
            this.getRealConnection().setDrdaID(drdaID);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public final void setPrepareIsolation(int level) throws SQLException {
        this.getRealConnection().setPrepareIsolation(level);
    }

    public final int getPrepareIsolation() throws SQLException {
        return this.getRealConnection().getPrepareIsolation();
    }

    public final void addWarning(SQLWarning w) throws SQLException {
        this.getRealConnection().addWarning(w);
    }

    protected final void checkIfClosed() throws SQLException {
        if (this.isClosed()) {
            throw Util.noCurrentConnection();
        }
    }

    public String toString() {
        if (this.connString == null) {
            String wrappedString;
            try {
                wrappedString = this.getRealConnection().toString();
            }
            catch (SQLException e) {
                wrappedString = "<none>";
            }
            this.connString = this.getClass().getName() + "@" + this.hashCode() + ", Wrapped Connection = " + wrappedString;
        }
        return this.connString;
    }

    int getJDBCLevel() {
        return 2;
    }

    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            resultSetHoldability = this.statementHoldabilityCheck(resultSetHoldability);
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql, null);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    public final int getHoldability() throws SQLException {
        try {
            return this.getRealConnection().getHoldability();
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    final int statementHoldabilityCheck(int resultSetHoldability) throws SQLException {
        int holdability = this.control.checkHoldCursors(resultSetHoldability, true);
        if (holdability != resultSetHoldability) {
            SQLWarning w = EmbedSQLWarning.newEmbedSQLWarning("01J07");
            this.addWarning(w);
        }
        return holdability;
    }

    public int addLOBMapping(Object LOBReference) throws SQLException {
        return this.getRealConnection().addLOBMapping(LOBReference);
    }

    public void clearLOBMapping() throws SQLException {
        this.getRealConnection().clearLOBMapping();
    }

    public Object getLOBMapping(int key) throws SQLException {
        return this.getRealConnection().getLOBMapping(key);
    }
}

