/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.derby.iapi.jdbc.BrokeredPreparedStatement;
import org.apache.derby.iapi.jdbc.BrokeredStatementControl;

public abstract class BrokeredCallableStatement
extends BrokeredPreparedStatement
implements CallableStatement {
    public BrokeredCallableStatement(BrokeredStatementControl control, int jdbcLevel, String sql) throws SQLException {
        super(control, jdbcLevel, sql);
    }

    public final void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.getCallableStatement().registerOutParameter(parameterIndex, sqlType);
    }

    public final void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.getCallableStatement().registerOutParameter(parameterIndex, sqlType, scale);
    }

    public final boolean wasNull() throws SQLException {
        return this.getCallableStatement().wasNull();
    }

    public final String getString(int parameterIndex) throws SQLException {
        return this.getCallableStatement().getString(parameterIndex);
    }

    public final boolean getBoolean(int parameterIndex) throws SQLException {
        return this.getCallableStatement().getBoolean(parameterIndex);
    }

    public final byte getByte(int parameterIndex) throws SQLException {
        return this.getCallableStatement().getByte(parameterIndex);
    }

    public final short getShort(int parameterIndex) throws SQLException {
        return this.getCallableStatement().getShort(parameterIndex);
    }

    public final int getInt(int parameterIndex) throws SQLException {
        return this.getCallableStatement().getInt(parameterIndex);
    }

    public final long getLong(int parameterIndex) throws SQLException {
        return this.getCallableStatement().getLong(parameterIndex);
    }

    public final float getFloat(int parameterIndex) throws SQLException {
        return this.getCallableStatement().getFloat(parameterIndex);
    }

    public final double getDouble(int parameterIndex) throws SQLException {
        return this.getCallableStatement().getDouble(parameterIndex);
    }

    public final BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        return this.getCallableStatement().getBigDecimal(parameterIndex, scale);
    }

    public final byte[] getBytes(int parameterIndex) throws SQLException {
        return this.getCallableStatement().getBytes(parameterIndex);
    }

    public final Date getDate(int parameterIndex) throws SQLException {
        return this.getCallableStatement().getDate(parameterIndex);
    }

    public final Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return this.getCallableStatement().getDate(parameterIndex, cal);
    }

    public final Time getTime(int parameterIndex) throws SQLException {
        return this.getCallableStatement().getTime(parameterIndex);
    }

    public final Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.getCallableStatement().getTimestamp(parameterIndex);
    }

    public final Object getObject(int parameterIndex) throws SQLException {
        return this.getCallableStatement().getObject(parameterIndex);
    }

    public final BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return this.getCallableStatement().getBigDecimal(parameterIndex);
    }

    public final Object getObject(int i, Map map) throws SQLException {
        return this.getCallableStatement().getObject(i, map);
    }

    public final Ref getRef(int i) throws SQLException {
        return this.getCallableStatement().getRef(i);
    }

    public final Blob getBlob(int i) throws SQLException {
        return this.getCallableStatement().getBlob(i);
    }

    public final Clob getClob(int i) throws SQLException {
        return this.getCallableStatement().getClob(i);
    }

    public final Array getArray(int i) throws SQLException {
        return this.getCallableStatement().getArray(i);
    }

    public final Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return this.getCallableStatement().getTime(parameterIndex, cal);
    }

    public final Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return this.getCallableStatement().getTimestamp(parameterIndex, cal);
    }

    public final void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.getCallableStatement().registerOutParameter(paramIndex, sqlType, typeName);
    }

    final CallableStatement getCallableStatement() throws SQLException {
        return this.control.getRealCallableStatement();
    }

    final PreparedStatement getPreparedStatement() throws SQLException {
        return this.getCallableStatement();
    }

    public CallableStatement createDuplicateStatement(Connection conn, CallableStatement oldStatement) throws SQLException {
        CallableStatement newStatement = conn.prepareCall(this.sql, this.resultSetType, this.resultSetConcurrency);
        this.setStatementState(oldStatement, newStatement);
        return newStatement;
    }
}

