/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.error;

import java.sql.SQLException;
import java.sql.SQLWarning;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.impl.jdbc.EmbedSQLException;
import org.apache.derby.impl.jdbc.Util;

public class StandardException
extends Exception {
    public static final int REPORT_DEFAULT = 0;
    public static final int REPORT_NEVER = 1;
    public static final int REPORT_ALWAYS = 2;
    private transient Object[] arguments;
    private int severity;
    private String textMessage;
    private String sqlState;
    private transient int report;

    protected StandardException(String messageID) {
        this(messageID, null, null);
    }

    protected StandardException(String messageID, Object[] args) {
        this(messageID, null, args);
    }

    protected StandardException(String messageID, Throwable t, Object[] args) {
        super(messageID);
        this.severity = StandardException.getSeverityFromIdentifier(messageID);
        this.sqlState = StandardException.getSQLStateFromIdentifier(messageID);
        this.arguments = args;
        if (t != null) {
            this.initCause(t);
        }
        SanityManager.ASSERT(messageID != null, "StandardException with no messageID");
    }

    private StandardException(String sqlState, String text) {
        this(sqlState);
        this.textMessage = text;
    }

    private final void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    public final Object[] getArguments() {
        return this.arguments;
    }

    public final int report() {
        return this.report;
    }

    public final void setReport(int report) {
        this.report = report;
    }

    public final void setSeverity(int severity) {
        this.severity = severity;
    }

    public final int getSeverity() {
        return this.severity;
    }

    public final int getErrorCode() {
        return this.severity;
    }

    public final String getSQLState() {
        return this.sqlState;
    }

    public static String getSQLStateFromIdentifier(String messageID) {
        if (messageID.length() == 5) {
            return messageID;
        }
        return messageID.substring(0, 5);
    }

    public static int getSeverityFromIdentifier(String messageID) {
        int lseverity = 0;
        block0 : switch (messageID.length()) {
            case 5: {
                block3 : switch (messageID.charAt(0)) {
                    case '0': {
                        switch (messageID.charAt(1)) {
                            case '1': {
                                lseverity = 10000;
                                break;
                            }
                            case '7': 
                            case 'A': {
                                lseverity = 20000;
                                break;
                            }
                            case '8': {
                                lseverity = 40000;
                            }
                        }
                        break;
                    }
                    case '2': 
                    case '3': {
                        lseverity = 20000;
                        break;
                    }
                    case '4': {
                        switch (messageID.charAt(1)) {
                            case '0': {
                                lseverity = 30000;
                                break block3;
                            }
                            case '2': {
                                lseverity = 20000;
                            }
                        }
                    }
                }
                break;
            }
            default: {
                switch (messageID.charAt(6)) {
                    case 'M': {
                        lseverity = 50000;
                        break block0;
                    }
                    case 'D': {
                        lseverity = 45000;
                        break block0;
                    }
                    case 'C': {
                        lseverity = 40000;
                        break block0;
                    }
                    case 'T': {
                        lseverity = 30000;
                        break block0;
                    }
                    case 'S': {
                        lseverity = 20000;
                        break block0;
                    }
                    case 'U': {
                        lseverity = 0;
                    }
                }
            }
        }
        return lseverity;
    }

    public static StandardException normalClose() {
        StandardException se = StandardException.newException("XXXXX.C.6");
        se.report = 1;
        return se;
    }

    public static StandardException newException(String messageID) {
        return new StandardException(messageID);
    }

    public static StandardException newException(String messageID, Throwable t) {
        return new StandardException(messageID, t, null);
    }

    public static StandardException newException(String messageID, Object a1) {
        Object[] oa = new Object[]{a1};
        return new StandardException(messageID, oa);
    }

    public static StandardException newException(String messageID, Throwable t, Object a1) {
        Object[] oa = new Object[]{a1};
        return new StandardException(messageID, t, oa);
    }

    public static StandardException newException(String messageID, Object a1, Object a2) {
        Object[] oa = new Object[]{a1, a2};
        return new StandardException(messageID, oa);
    }

    public static StandardException newException(String messageID, Object a1, Throwable t) throws BadMessageArgumentException {
        throw new BadMessageArgumentException();
    }

    public static StandardException newException(String messageID, Throwable t, Object a1, Object a2) {
        Object[] oa = new Object[]{a1, a2};
        return new StandardException(messageID, t, oa);
    }

    public static StandardException newException(String messageID, Object a1, Object a2, Object a3) {
        Object[] oa = new Object[]{a1, a2, a3};
        return new StandardException(messageID, oa);
    }

    public static StandardException newException(String messageID, Object a1, Object a2, Throwable t) throws BadMessageArgumentException {
        throw new BadMessageArgumentException();
    }

    public static StandardException newException(String messageID, Throwable t, Object a1, Object a2, Object a3) {
        Object[] oa = new Object[]{a1, a2, a3};
        return new StandardException(messageID, t, oa);
    }

    public static StandardException newException(String messageID, Object a1, Object a2, Object a3, Object a4) {
        Object[] oa = new Object[]{a1, a2, a3, a4};
        return new StandardException(messageID, oa);
    }

    public static StandardException newException(String messageID, Throwable t, Object a1, Object a2, Object a3, Object a4) {
        Object[] oa = new Object[]{a1, a2, a3, a4};
        return new StandardException(messageID, t, oa);
    }

    public static StandardException newException(String messageID, Object a1, Object a2, Object a3, Object a4, Object a5) {
        Object[] oa = new Object[]{a1, a2, a3, a4, a5};
        return new StandardException(messageID, oa);
    }

    public static StandardException newException(String messageID, Throwable t, Object a1, Object a2, Object a3, Object a4, Object a5) {
        Object[] oa = new Object[]{a1, a2, a3, a4, a5};
        return new StandardException(messageID, t, oa);
    }

    public static StandardException newException(String messageID, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6) {
        Object[] oa = new Object[]{a1, a2, a3, a4, a5, a6};
        return new StandardException(messageID, oa);
    }

    public static StandardException newException(String messageID, Throwable t, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6) {
        Object[] oa = new Object[]{a1, a2, a3, a4, a5, a6};
        return new StandardException(messageID, t, oa);
    }

    public static StandardException newException(String messageID, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7) {
        Object[] oa = new Object[]{a1, a2, a3, a4, a5, a6, a7};
        return new StandardException(messageID, oa);
    }

    public static StandardException newException(String messageID, Throwable t, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7) {
        Object[] oa = new Object[]{a1, a2, a3, a4, a5, a6, a7};
        return new StandardException(messageID, t, oa);
    }

    public static StandardException newException(String messageID, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7, Object a8) {
        Object[] oa = new Object[]{a1, a2, a3, a4, a5, a6, a7, a8};
        return new StandardException(messageID, oa);
    }

    public static StandardException newException(String messageID, Throwable t, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7, Object a8) {
        Object[] oa = new Object[]{a1, a2, a3, a4, a5, a6, a7, a8};
        return new StandardException(messageID, t, oa);
    }

    public static StandardException newPreLocalizedException(String MessageID, Throwable t, String localizedMessage) {
        StandardException se = new StandardException(MessageID, localizedMessage);
        if (t != null) {
            se.initCause(t);
        }
        return se;
    }

    public static StandardException unexpectedUserException(Throwable t) {
        String detailMessage;
        Throwable wrapped;
        SQLException sqlex;
        String state;
        SQLException sqle;
        EmbedSQLException ferry = null;
        if (t instanceof SQLException && (sqle = Util.getExceptionFactory().getArgumentFerry((SQLException)t)) instanceof EmbedSQLException) {
            ferry = (EmbedSQLException)sqle;
        }
        if (t instanceof SQLException && ferry == null && (state = (sqlex = (SQLException)t).getSQLState()) != null && state.length() == 5 && state.startsWith("38") && !state.equals("38000")) {
            StandardException se = new StandardException(state, sqlex.getMessage());
            if (sqlex.getNextException() != null) {
                se.initCause(sqlex.getNextException());
            }
            return se;
        }
        if (ferry != null && ferry.isSimpleWrapper() && (wrapped = ferry.getCause()) instanceof StandardException) {
            return (StandardException)wrapped;
        }
        if (t instanceof StandardException) {
            return (StandardException)t;
        }
        boolean derbyException = false;
        if (ferry != null) {
            detailMessage = ferry.toString();
            derbyException = true;
        } else {
            detailMessage = t.getMessage();
        }
        detailMessage = detailMessage == null ? "" : detailMessage.trim();
        if (detailMessage.length() == 0) {
            detailMessage = t.getClass().getName();
        } else if (!derbyException) {
            detailMessage = t.getClass().getName() + ": " + detailMessage;
        }
        StandardException se = StandardException.newException("38000", t, (Object)detailMessage);
        return se;
    }

    public static StandardException plainWrapException(Throwable t) {
        SQLException sqle;
        String sqlState;
        if (t instanceof StandardException) {
            return (StandardException)t;
        }
        if (t instanceof SQLException && (sqlState = (sqle = (SQLException)t).getSQLState()) != null) {
            StandardException se = new StandardException(sqlState, "(" + sqle.getErrorCode() + ") " + sqle.getMessage());
            if ((sqle = sqle.getNextException()) != null) {
                se.initCause(StandardException.plainWrapException(sqle));
            }
            return se;
        }
        String detailMessage = t.getMessage();
        detailMessage = detailMessage == null ? "" : detailMessage.trim();
        StandardException se = StandardException.newException("XJ001.U", t, (Object)detailMessage, (Object)t.getClass().getName());
        return se;
    }

    public static StandardException closeException() {
        StandardException se = StandardException.newException("close.C.1");
        se.setReport(1);
        return se;
    }

    public String getMessage() {
        if (this.textMessage == null) {
            this.textMessage = MessageService.getCompleteMessage(this.getMessageId(), this.getArguments());
        }
        return this.textMessage;
    }

    public final String getMessageId() {
        return super.getMessage();
    }

    public String getErrorProperty(String type) {
        return StandardException.getErrorProperty(this.getMessageId(), type);
    }

    public String toString() {
        String msg = this.getMessage();
        return "ERROR " + this.getSQLState() + ": " + msg;
    }

    private static String getErrorProperty(String messageId, String type) {
        return MessageService.getProperty(messageId, type);
    }

    public static StandardException interrupt(InterruptedException ie) {
        StandardException se = StandardException.newException("08000", ie);
        return se;
    }

    public static SQLWarning newWarning(String messageId) {
        return StandardException.newWarningCommon(messageId, null);
    }

    public static SQLWarning newWarning(String messageId, Object a1) {
        Object[] oa = new Object[]{a1};
        return StandardException.newWarningCommon(messageId, oa);
    }

    public static SQLWarning newWarning(String messageId, Object a1, Object a2) {
        Object[] oa = new Object[]{a1, a2};
        return StandardException.newWarningCommon(messageId, oa);
    }

    private static SQLWarning newWarningCommon(String messageId, Object[] oa) {
        String message = MessageService.getCompleteMessage(messageId, oa);
        String state = StandardException.getSQLStateFromIdentifier(messageId);
        SQLWarning sqlw = new SQLWarning(message, state, 10000);
        return sqlw;
    }

    public static class BadMessageArgumentException
    extends Throwable {
    }
}

