/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.db;

import java.sql.SQLException;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;

public class OnlineCompress {
    private OnlineCompress() {
    }

    public static void compressTable(String schemaName, String tableName, boolean purgeRows, boolean defragmentRows, boolean truncateEnd) throws SQLException {
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        TransactionController tc = lcc.getTransactionExecute();
        try {
            DataDictionary data_dictionary = lcc.getDataDictionary();
            if (purgeRows) {
                OnlineCompress.purgeRows(schemaName, tableName, data_dictionary, tc);
            }
            if (defragmentRows) {
                OnlineCompress.defragmentRows(schemaName, tableName, data_dictionary, tc);
            }
            if (truncateEnd) {
                OnlineCompress.truncateEnd(schemaName, tableName, data_dictionary, tc);
            }
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void defragmentRows(String schemaName, String tableName, DataDictionary data_dictionary, TransactionController tc) throws SQLException {
        block30: {
            block29: {
                base_group_fetch_cc = null;
                num_indexes = 0;
                index_col_map /* !! */  = null;
                index_scan = null;
                index_cc = null;
                index_row = null;
                lcc = ConnectionUtil.getCurrentLCC();
                nested_tc = null;
                try {
                    try {
                        sd = data_dictionary.getSchemaDescriptor(schemaName, nested_tc, true);
                        td = data_dictionary.getTableDescriptor(tableName, sd);
                        nested_tc = tc.startNestedUserTransaction(false);
                        if (td == null) {
                            throw StandardException.newException("42X05", schemaName + "." + tableName);
                        }
                        switch (td.getTableType()) {
                            case 2: 
                            case 5: {
                                var26_15 = null;
                                break block29;
                            }
                            default: {
                                heapCD = td.getConglomerateDescriptor(td.getHeapConglomerateId());
                                baseRow = lcc.getLanguageConnectionFactory().getExecutionFactory().getValueRow(td.getNumberOfColumns());
                                cdl = td.getColumnDescriptorList();
                                cdlSize = cdl.size();
                                for (index = 0; index < cdlSize; ++index) {
                                    cd = cdl.elementAt(index);
                                    baseRow.setColumn(cd.getPosition(), cd.getType().getNull());
                                }
                                row_array = new DataValueDescriptor[100][];
                                row_array[0] = baseRow.getRowArray();
                                old_row_location_array = new RowLocation[100];
                                new_row_location_array = new RowLocation[100];
                                conglom_descriptors = td.getConglomerateDescriptors();
                                num_indexes = conglom_descriptors.length - 1;
                                if (num_indexes > 0) {
                                    index_col_map /* !! */  = new int[num_indexes][];
                                    index_scan = new ScanController[num_indexes];
                                    index_cc = new ConglomerateController[num_indexes];
                                    index_row = new DataValueDescriptor[num_indexes][];
                                    OnlineCompress.setup_indexes(nested_tc, td, index_col_map /* !! */ , index_scan, index_cc, index_row);
                                }
                                base_group_fetch_cc = nested_tc.defragmentConglomerate(td.getHeapConglomerateId(), false, true, 4, 7, 5);
                                num_rows_fetched = 0;
                                while ((num_rows_fetched = base_group_fetch_cc.fetchNextGroup(row_array, old_row_location_array, new_row_location_array)) != 0) {
                                    if (num_indexes <= 0) continue;
                                    for (row = 0; row < num_rows_fetched; ++row) {
                                        for (index = 0; index < num_indexes; ++index) {
                                            OnlineCompress.fixIndex(row_array[row], index_row[index], old_row_location_array[row], new_row_location_array[row], index_cc[index], index_scan[index], index_col_map /* !! */ [index]);
                                        }
                                    }
                                }
                                nested_tc.commit();
                                break;
                            }
                        }
                        break block30;
                    }
                    catch (StandardException se) {
                        throw PublicAPI.wrapStandardException(se);
                    }
                }
                catch (Throwable var25_36) {
                    var26_17 = null;
                    try {
                        if (base_group_fetch_cc != null) {
                            base_group_fetch_cc.close();
                            base_group_fetch_cc = null;
                        }
                        if (num_indexes > 0) {
                            for (i = 0; i < num_indexes; ++i) {
                                if (index_scan != null && index_scan[i] != null) {
                                    index_scan[i].close();
                                    index_scan[i] = null;
                                }
                                if (index_cc == null || index_cc[i] == null) continue;
                                index_cc[i].close();
                                index_cc[i] = null;
                            }
                        }
                        if (nested_tc == null) throw var25_36;
                        nested_tc.destroy();
                        throw var25_36;
                    }
                    catch (StandardException se) {
                        throw PublicAPI.wrapStandardException(se);
                    }
                }
            }
            ** try [egrp 2[TRYBLOCK] [5 : 472->581)] { 
lbl80:
            // 1 sources

            if (base_group_fetch_cc != null) {
                base_group_fetch_cc.close();
                base_group_fetch_cc = null;
            }
            if (num_indexes > 0) {
                for (i = 0; i < num_indexes; ++i) {
                    if (index_scan != null && index_scan[i] != null) {
                        index_scan[i].close();
                        index_scan[i] = null;
                    }
                    if (index_cc == null || index_cc[i] == null) continue;
                    index_cc[i].close();
                    index_cc[i] = null;
                }
            }
            if (nested_tc == null) return;
            nested_tc.destroy();
            return;
lbl95:
            // 1 sources

            catch (StandardException se) {
                throw PublicAPI.wrapStandardException(se);
            }
        }
        var26_16 = null;
        ** try [egrp 2[TRYBLOCK] [5 : 472->581)] { 
lbl100:
        // 1 sources

        if (base_group_fetch_cc != null) {
            base_group_fetch_cc.close();
            base_group_fetch_cc = null;
        }
        if (num_indexes > 0) {
            for (i = 0; i < num_indexes; ++i) {
                if (index_scan != null && index_scan[i] != null) {
                    index_scan[i].close();
                    index_scan[i] = null;
                }
                if (index_cc == null || index_cc[i] == null) continue;
                index_cc[i].close();
                index_cc[i] = null;
            }
        }
        if (nested_tc == null) return;
        nested_tc.destroy();
        return;
lbl115:
        // 1 sources

        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    private static void purgeRows(String schemaName, String tableName, DataDictionary data_dictionary, TransactionController tc) throws StandardException {
        SchemaDescriptor sd = data_dictionary.getSchemaDescriptor(schemaName, tc, true);
        TableDescriptor td = data_dictionary.getTableDescriptor(tableName, sd);
        if (td == null) {
            throw StandardException.newException("42X05", schemaName + "." + tableName);
        }
        switch (td.getTableType()) {
            case 2: 
            case 5: {
                break;
            }
            default: {
                ConglomerateDescriptor[] conglom_descriptors = td.getConglomerateDescriptors();
                for (int cd_idx = 0; cd_idx < conglom_descriptors.length; ++cd_idx) {
                    ConglomerateDescriptor cd = conglom_descriptors[cd_idx];
                    tc.purgeConglomerate(cd.getConglomerateNumber());
                }
            }
        }
    }

    private static void truncateEnd(String schemaName, String tableName, DataDictionary data_dictionary, TransactionController tc) throws StandardException {
        SchemaDescriptor sd = data_dictionary.getSchemaDescriptor(schemaName, tc, true);
        TableDescriptor td = data_dictionary.getTableDescriptor(tableName, sd);
        if (td == null) {
            throw StandardException.newException("42X05", schemaName + "." + tableName);
        }
        switch (td.getTableType()) {
            case 2: 
            case 5: {
                break;
            }
            default: {
                ConglomerateDescriptor[] conglom_descriptors = td.getConglomerateDescriptors();
                for (int cd_idx = 0; cd_idx < conglom_descriptors.length; ++cd_idx) {
                    ConglomerateDescriptor cd = conglom_descriptors[cd_idx];
                    tc.compressConglomerate(cd.getConglomerateNumber());
                }
            }
        }
    }

    private static void setup_indexes(TransactionController tc, TableDescriptor td, int[][] index_col_map, ScanController[] index_scan, ConglomerateController[] index_cc, DataValueDescriptor[][] index_row) throws StandardException {
        ConglomerateDescriptor[] conglom_descriptors = td.getConglomerateDescriptors();
        int index_idx = 0;
        for (int cd_idx = 0; cd_idx < conglom_descriptors.length; ++cd_idx) {
            ConglomerateDescriptor index_cd = conglom_descriptors[cd_idx];
            if (!index_cd.isIndex()) continue;
            index_scan[index_idx] = tc.openScan(index_cd.getConglomerateNumber(), true, 4, 7, 5, null, null, 0, null, null, 0);
            index_cc[index_idx] = tc.openConglomerate(index_cd.getConglomerateNumber(), true, 4, 7, 5);
            int[] baseColumnPositions = index_cd.getIndexDescriptor().baseColumnPositions();
            int[] zero_based_map = new int[baseColumnPositions.length];
            for (int i = 0; i < baseColumnPositions.length; ++i) {
                zero_based_map[i] = baseColumnPositions[i] - 1;
            }
            index_col_map[index_idx] = zero_based_map;
            index_row[index_idx] = new DataValueDescriptor[baseColumnPositions.length + 1];
            ++index_idx;
        }
    }

    private static void fixIndex(DataValueDescriptor[] base_row, DataValueDescriptor[] index_row, RowLocation old_row_loc, RowLocation new_row_loc, ConglomerateController index_cc, ScanController index_scan, int[] index_col_map) throws StandardException {
        SanityManager.ASSERT(index_col_map != null);
        SanityManager.ASSERT(index_row != null);
        SanityManager.ASSERT(index_col_map.length == index_row.length - 1);
        for (int index = 0; index < index_col_map.length; ++index) {
            index_row[index] = base_row[index_col_map[index]];
        }
        index_row[index_row.length - 1] = old_row_loc;
        index_scan.reopenScan(index_row, 1, null, index_row, -1);
        if (index_scan.next()) {
            index_scan.delete();
        } else {
            SanityManager.THROWASSERT("Did not find row to delete.base_row = " + RowUtil.toString(base_row) + "index_row = " + RowUtil.toString(index_row));
        }
        index_row[index_row.length - 1] = new_row_loc;
        index_cc.insert(index_row);
    }
}

