/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.diag;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.diag.ConglomInfo;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.SpaceInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.vti.VTICosting;
import org.apache.derby.vti.VTIEnvironment;
import org.apache.derby.vti.VTITemplate;

public class SpaceTable
extends VTITemplate
implements VTICosting {
    private ConglomInfo[] conglomTable;
    boolean initialized;
    int currentRow;
    private boolean wasNull;
    private String schemaName;
    private String tableName;
    private SpaceInfo spaceInfo;
    private TransactionController tc;
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("CONGLOMERATENAME", 12, true, 128), EmbedResultSetMetaData.getResultColumnDescriptor("ISINDEX", 5, false), EmbedResultSetMetaData.getResultColumnDescriptor("NUMALLOCATEDPAGES", -5, false), EmbedResultSetMetaData.getResultColumnDescriptor("NUMFREEPAGES", -5, false), EmbedResultSetMetaData.getResultColumnDescriptor("NUMUNFILLEDPAGES", -5, false), EmbedResultSetMetaData.getResultColumnDescriptor("PAGESIZE", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("ESTIMSPACESAVING", -5, false)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    public SpaceTable(String schemaName, String tableName) {
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    public SpaceTable(String tableName) {
        this.tableName = tableName;
    }

    private void getConglomInfo(LanguageConnectionContext lcc) throws StandardException {
        SchemaDescriptor sd;
        TableDescriptor td;
        DataDictionary dd = lcc.getDataDictionary();
        if (this.schemaName == null) {
            this.schemaName = lcc.getCurrentSchemaName();
        }
        if ((td = dd.getTableDescriptor(this.tableName, sd = dd.getSchemaDescriptor(this.schemaName, lcc.getTransactionExecute(), true))) == null) {
            this.conglomTable = new ConglomInfo[0];
            return;
        }
        ConglomerateDescriptor[] cds = td.getConglomerateDescriptors();
        this.conglomTable = new ConglomInfo[cds.length];
        for (int i = 0; i < cds.length; ++i) {
            this.conglomTable[i] = new ConglomInfo(cds[i].getConglomerateNumber(), cds[i].isIndex() ? cds[i].getConglomerateName() : this.tableName, cds[i].isIndex());
        }
    }

    private void getSpaceInfo(int index) throws StandardException {
        ConglomerateController cc = this.tc.openConglomerate(this.conglomTable[index].getConglomId(), false, 0, 6, 2);
        this.spaceInfo = cc.getSpaceInfo();
        cc.close();
        cc = null;
    }

    public ResultSetMetaData getMetaData() {
        return metadata;
    }

    public boolean next() throws SQLException {
        try {
            if (!this.initialized) {
                LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
                this.getConglomInfo(lcc);
                this.tc = lcc.getTransactionExecute();
                this.initialized = true;
                this.currentRow = -1;
            }
            if (this.conglomTable == null) {
                return false;
            }
            ++this.currentRow;
            if (this.currentRow >= this.conglomTable.length) {
                return false;
            }
            this.spaceInfo = null;
            this.getSpaceInfo(this.currentRow);
            return true;
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public void close() {
        this.conglomTable = null;
        this.spaceInfo = null;
        this.tc = null;
    }

    public String getString(int columnNumber) {
        ConglomInfo conglomInfo = this.conglomTable[this.currentRow];
        String str = conglomInfo.getConglomName();
        this.wasNull = str == null;
        return str;
    }

    public long getLong(int columnNumber) {
        long longval;
        ConglomInfo conglomInfo = this.conglomTable[this.currentRow];
        switch (columnNumber) {
            case 3: {
                longval = this.spaceInfo.getNumAllocatedPages();
                break;
            }
            case 4: {
                longval = this.spaceInfo.getNumFreePages();
                break;
            }
            case 5: {
                longval = this.spaceInfo.getNumUnfilledPages();
                break;
            }
            case 7: {
                int psize = this.spaceInfo.getPageSize();
                longval = this.spaceInfo.getNumFreePages() * (long)psize;
                break;
            }
            default: {
                longval = -1L;
            }
        }
        this.wasNull = false;
        if (longval < 0L) {
            SanityManager.THROWASSERT("SpaceTable column number " + columnNumber + " has a negative value at row " + this.currentRow);
        }
        return longval;
    }

    public short getShort(int columnNumber) {
        ConglomInfo conglomInfo = this.conglomTable[this.currentRow];
        this.wasNull = false;
        return (short)(conglomInfo.getIsIndex() ? 1 : 0);
    }

    public int getInt(int columnNumber) {
        return this.spaceInfo.getPageSize();
    }

    public boolean wasNull() {
        return this.wasNull;
    }

    public double getEstimatedRowCount(VTIEnvironment vtiEnvironment) {
        return 10000.0;
    }

    public double getEstimatedCostPerInstantiation(VTIEnvironment vtiEnvironment) {
        return 100000.0;
    }

    public boolean supportsMultipleInstantiations(VTIEnvironment vtiEnvironment) {
        return true;
    }
}

