/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.BaseTypeIdImpl;
import org.apache.derby.iapi.services.io.Formatable;

public class TypeDescriptorImpl
implements TypeDescriptor,
Formatable {
    private BaseTypeIdImpl typeId;
    private int precision;
    private int scale;
    private boolean isNullable;
    private int maximumWidth;
    private int collationType = 0;
    private int collationDerivation = 1;

    public TypeDescriptorImpl() {
    }

    public TypeDescriptorImpl(BaseTypeIdImpl typeId, int precision, int scale, boolean isNullable, int maximumWidth) {
        this.typeId = typeId;
        this.precision = precision;
        this.scale = scale;
        this.isNullable = isNullable;
        this.maximumWidth = maximumWidth;
    }

    public TypeDescriptorImpl(BaseTypeIdImpl typeId, int precision, int scale, boolean isNullable, int maximumWidth, int collationType, int collationDerivation) {
        this.typeId = typeId;
        this.precision = precision;
        this.scale = scale;
        this.isNullable = isNullable;
        this.maximumWidth = maximumWidth;
        this.collationType = collationType;
        this.collationDerivation = collationDerivation;
    }

    public TypeDescriptorImpl(BaseTypeIdImpl typeId, boolean isNullable, int maximumWidth) {
        this.typeId = typeId;
        this.isNullable = isNullable;
        this.maximumWidth = maximumWidth;
    }

    public TypeDescriptorImpl(TypeDescriptorImpl source, int precision, int scale, boolean isNullable, int maximumWidth) {
        this.typeId = source.typeId;
        this.precision = precision;
        this.scale = scale;
        this.isNullable = isNullable;
        this.maximumWidth = maximumWidth;
    }

    public TypeDescriptorImpl(TypeDescriptorImpl source, int precision, int scale, boolean isNullable, int maximumWidth, int collationType, int collationDerivation) {
        this.typeId = source.typeId;
        this.precision = precision;
        this.scale = scale;
        this.isNullable = isNullable;
        this.maximumWidth = maximumWidth;
        this.collationType = collationType;
        this.collationDerivation = collationDerivation;
    }

    public TypeDescriptorImpl(TypeDescriptorImpl source, boolean isNullable, int maximumWidth) {
        this.typeId = source.typeId;
        this.precision = source.precision;
        this.scale = source.scale;
        this.isNullable = isNullable;
        this.maximumWidth = maximumWidth;
    }

    public int getMaximumWidth() {
        return this.maximumWidth;
    }

    public int getMaximumWidthInBytes() {
        switch (this.typeId.getJDBCTypeId()) {
            case -7: 
            case -6: 
            case -4: 
            case -3: 
            case -2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 2004: {
                return this.maximumWidth;
            }
            case -5: {
                return 40;
            }
            case 91: 
            case 92: {
                return 6;
            }
            case 93: {
                return 16;
            }
            case 2: 
            case 3: {
                return 2 * (this.precision + 2);
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                if (this.maximumWidth > 0 && 2 * this.maximumWidth < 0) {
                    return Integer.MAX_VALUE;
                }
                return 2 * this.maximumWidth;
            }
        }
        return -1;
    }

    public int getJDBCTypeId() {
        return this.typeId.getJDBCTypeId();
    }

    public String getTypeName() {
        return this.typeId.getSQLTypeName();
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public void setNullability(boolean nullable) {
        this.isNullable = nullable;
    }

    public int getCollationType() {
        return this.collationType;
    }

    public void setCollationType(int collationTypeValue) {
        this.collationType = collationTypeValue;
    }

    public int getCollationDerivation() {
        return this.collationDerivation;
    }

    public void setCollationDerivation(int collationDerivationValue) {
        this.collationDerivation = collationDerivationValue;
    }

    public String getCollationName() {
        return this.collationDerivation == 0 ? "NONE" : (this.collationType == 0 ? "UCS_BASIC" : "TERRITORY_BASED");
    }

    public String getSQLstring() {
        return this.typeId.toParsableString(this);
    }

    public String toString() {
        String s = this.getSQLstring();
        if (!this.isNullable()) {
            return s + " NOT NULL";
        }
        return s;
    }

    public BaseTypeIdImpl getTypeId() {
        return this.typeId;
    }

    public boolean equals(Object object) {
        TypeDescriptor typeDescriptor = (TypeDescriptor)object;
        if (!this.getTypeName().equals(typeDescriptor.getTypeName()) || this.precision != typeDescriptor.getPrecision() || this.scale != typeDescriptor.getScale() || this.isNullable != typeDescriptor.isNullable() || this.maximumWidth != typeDescriptor.getMaximumWidth()) {
            return false;
        }
        switch (this.typeId.getJDBCTypeId()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return this.collationDerivation == typeDescriptor.getCollationDerivation() && this.collationType == typeDescriptor.getCollationType();
            }
        }
        return true;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.typeId = (BaseTypeIdImpl)in.readObject();
        this.precision = in.readInt();
        switch (this.typeId.getJDBCTypeId()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                this.scale = 0;
                this.collationType = in.readInt();
                this.collationDerivation = 1;
                break;
            }
            default: {
                this.scale = in.readInt();
                this.collationType = 0;
                this.collationDerivation = 1;
            }
        }
        this.isNullable = in.readBoolean();
        this.maximumWidth = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.typeId);
        out.writeInt(this.precision);
        switch (this.typeId.getJDBCTypeId()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                out.writeInt(this.collationType);
                break;
            }
            default: {
                out.writeInt(this.scale);
            }
        }
        out.writeBoolean(this.isNullable);
        out.writeInt(this.maximumWidth);
    }

    public int getTypeFormatId() {
        return 14;
    }
}

