/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.MethodAliasInfo;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.sanity.SanityManager;

public class RoutineAliasInfo
extends MethodAliasInfo {
    private static final String[] SQL_CONTROL = new String[]{"MODIFIES SQL DATA", "READS SQL DATA", "CONTAINS SQL", "NO SQL"};
    public static final short MODIFIES_SQL_DATA = 0;
    public static final short READS_SQL_DATA = 1;
    public static final short CONTAINS_SQL = 2;
    public static final short NO_SQL = 3;
    public static final short PS_JAVA = 0;
    private int parameterCount;
    private TypeDescriptor[] parameterTypes;
    private String[] parameterNames;
    private int[] parameterModes;
    private int dynamicResultSets;
    private TypeDescriptor returnType;
    private short parameterStyle;
    private short sqlAllowed;
    private String specificName;
    private boolean calledOnNullInput;
    private transient char aliasType;

    public RoutineAliasInfo() {
    }

    public RoutineAliasInfo(String methodName, int parameterCount, String[] parameterNames, TypeDescriptor[] parameterTypes, int[] parameterModes, int dynamicResultSets, short parameterStyle, short sqlAllowed) {
        this(methodName, parameterCount, parameterNames, parameterTypes, parameterModes, dynamicResultSets, parameterStyle, sqlAllowed, true, null);
    }

    public RoutineAliasInfo(String methodName, int parameterCount, String[] parameterNames, TypeDescriptor[] parameterTypes, int[] parameterModes, int dynamicResultSets, short parameterStyle, short sqlAllowed, boolean calledOnNullInput, TypeDescriptor returnType) {
        super(methodName);
        this.parameterCount = parameterCount;
        this.parameterNames = parameterNames;
        this.parameterTypes = parameterTypes;
        this.parameterModes = parameterModes;
        this.dynamicResultSets = dynamicResultSets;
        this.parameterStyle = parameterStyle;
        this.sqlAllowed = sqlAllowed;
        this.calledOnNullInput = calledOnNullInput;
        this.returnType = returnType;
        if (parameterCount != 0 && parameterNames.length != parameterCount) {
            SanityManager.THROWASSERT("Invalid parameterNames array " + parameterNames.length + " != " + parameterCount);
        } else if (parameterCount == 0 && parameterNames != null && parameterNames.length != 0) {
            SanityManager.THROWASSERT("Invalid parameterNames array  not zero  != " + parameterCount);
        }
        if (parameterCount != 0 && parameterTypes.length != parameterCount) {
            SanityManager.THROWASSERT("Invalid parameterTypes array " + parameterTypes.length + " != " + parameterCount);
        } else if (parameterCount == 0 && parameterTypes != null && parameterTypes.length != 0) {
            SanityManager.THROWASSERT("Invalid parameterTypes array  not zero  != " + parameterCount);
        }
        if (parameterCount != 0 && parameterModes.length != parameterCount) {
            SanityManager.THROWASSERT("Invalid parameterModes array " + parameterModes.length + " != " + parameterCount);
        } else if (parameterCount == 0 && parameterModes != null && parameterModes.length != 0) {
            SanityManager.THROWASSERT("Invalid parameterModes array  not zero  != " + parameterCount);
        }
        if (returnType != null) {
            if (sqlAllowed < 1 || sqlAllowed > 3) {
                SanityManager.THROWASSERT("Invalid sqlAllowed for FUNCTION " + methodName + " " + sqlAllowed);
            }
        } else if (sqlAllowed < 0 || sqlAllowed > 3) {
            SanityManager.THROWASSERT("Invalid sqlAllowed for PROCEDURE " + methodName + " " + sqlAllowed);
        }
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public TypeDescriptor[] getParameterTypes() {
        return this.parameterTypes;
    }

    public int[] getParameterModes() {
        return this.parameterModes;
    }

    public String[] getParameterNames() {
        return this.parameterNames;
    }

    public int getMaxDynamicResultSets() {
        return this.dynamicResultSets;
    }

    public short getParameterStyle() {
        return this.parameterStyle;
    }

    public short getSQLAllowed() {
        return this.sqlAllowed;
    }

    public boolean calledOnNullInput() {
        return this.calledOnNullInput;
    }

    public TypeDescriptor getReturnType() {
        return this.returnType;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.specificName = (String)in.readObject();
        this.dynamicResultSets = in.readInt();
        this.parameterCount = in.readInt();
        this.parameterStyle = in.readShort();
        this.sqlAllowed = in.readShort();
        this.returnType = (TypeDescriptor)in.readObject();
        this.calledOnNullInput = in.readBoolean();
        in.readInt();
        if (this.parameterCount != 0) {
            this.parameterNames = new String[this.parameterCount];
            this.parameterTypes = new TypeDescriptor[this.parameterCount];
            ArrayUtil.readArrayItems(in, this.parameterNames);
            ArrayUtil.readArrayItems(in, this.parameterTypes);
            this.parameterModes = ArrayUtil.readIntArray(in);
        } else {
            this.parameterNames = null;
            this.parameterTypes = null;
            this.parameterModes = null;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.specificName);
        out.writeInt(this.dynamicResultSets);
        out.writeInt(this.parameterCount);
        out.writeShort(this.parameterStyle);
        out.writeShort(this.sqlAllowed);
        out.writeObject(this.returnType);
        out.writeBoolean(this.calledOnNullInput);
        out.writeInt(0);
        if (this.parameterCount != 0) {
            ArrayUtil.writeArrayItems(out, this.parameterNames);
            ArrayUtil.writeArrayItems(out, this.parameterTypes);
            ArrayUtil.writeIntArray(out, this.parameterModes);
        }
    }

    public int getTypeFormatId() {
        return 451;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append(this.getMethodName());
        sb.append('(');
        for (int i = 0; i < this.parameterCount; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            if (this.returnType == null) {
                sb.append(RoutineAliasInfo.parameterMode(this.parameterModes[i]));
                sb.append(' ');
            }
            sb.append(this.parameterNames[i]);
            sb.append(' ');
            sb.append(this.parameterTypes[i].getSQLstring());
        }
        sb.append(')');
        if (this.returnType != null) {
            sb.append(" RETURNS " + this.returnType.getSQLstring());
        }
        sb.append(" LANGUAGE JAVA PARAMETER STYLE JAVA ");
        sb.append(SQL_CONTROL[this.getSQLAllowed()]);
        if (this.returnType == null && this.dynamicResultSets != 0) {
            sb.append(" DYNAMIC RESULT SETS ");
            sb.append(this.dynamicResultSets);
        }
        if (this.returnType != null) {
            sb.append(this.calledOnNullInput ? " CALLED " : " RETURNS NULL ");
            sb.append("ON NULL INPUT");
        }
        return sb.toString();
    }

    public static String parameterMode(int parameterMode) {
        switch (parameterMode) {
            case 1: {
                return "IN";
            }
            case 4: {
                return "OUT";
            }
            case 2: {
                return "INOUT";
            }
        }
        return "UNKNOWN";
    }
}

