/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.IndexDescriptor;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableHashtable;

public class IndexDescriptorImpl
implements IndexDescriptor,
Formatable {
    private boolean isUnique;
    private int[] baseColumnPositions;
    private boolean[] isAscending;
    private int numberOfOrderedColumns;
    private String indexType;

    public IndexDescriptorImpl(String indexType, boolean isUnique, int[] baseColumnPositions, boolean[] isAscending, int numberOfOrderedColumns) {
        this.indexType = indexType;
        this.isUnique = isUnique;
        this.baseColumnPositions = baseColumnPositions;
        this.isAscending = isAscending;
        this.numberOfOrderedColumns = numberOfOrderedColumns;
    }

    public IndexDescriptorImpl() {
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public int[] baseColumnPositions() {
        return this.baseColumnPositions;
    }

    public Integer getKeyColumnPosition(Integer heapColumnPosition) {
        return new Integer(this.getKeyColumnPosition((int)heapColumnPosition));
    }

    public int getKeyColumnPosition(int heapColumnPosition) {
        int keyPosition = 0;
        for (int index = 0; index < this.baseColumnPositions.length; ++index) {
            if (this.baseColumnPositions[index] != heapColumnPosition) continue;
            keyPosition = index + 1;
            break;
        }
        return keyPosition;
    }

    public int numberOfOrderedColumns() {
        return this.numberOfOrderedColumns;
    }

    public String indexType() {
        return this.indexType;
    }

    public boolean isAscending(Integer keyColumnPosition) {
        int i = keyColumnPosition - 1;
        if (i < 0 || i >= this.baseColumnPositions.length) {
            return false;
        }
        return this.isAscending[i];
    }

    public boolean isDescending(Integer keyColumnPosition) {
        int i = keyColumnPosition - 1;
        if (i < 0 || i >= this.baseColumnPositions.length) {
            return false;
        }
        return !this.isAscending[i];
    }

    public boolean[] isAscending() {
        return this.isAscending;
    }

    public void setBaseColumnPositions(int[] baseColumnPositions) {
        this.baseColumnPositions = baseColumnPositions;
    }

    public void setIsAscending(boolean[] isAscending) {
        this.isAscending = isAscending;
    }

    public void setNumberOfOrderedColumns(int numberOfOrderedColumns) {
        this.numberOfOrderedColumns = numberOfOrderedColumns;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(60);
        if (this.isUnique) {
            sb.append("UNIQUE ");
        }
        sb.append(this.indexType);
        sb.append(" (");
        for (int i = 0; i < this.baseColumnPositions.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.baseColumnPositions[i]);
            if (this.isAscending[i]) continue;
            sb.append(" DESC");
        }
        sb.append(")");
        return sb.toString();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        FormatableHashtable fh = (FormatableHashtable)in.readObject();
        this.isUnique = fh.getBoolean("isUnique");
        int bcpLength = fh.getInt("keyLength");
        this.baseColumnPositions = new int[bcpLength];
        this.isAscending = new boolean[bcpLength];
        for (int i = 0; i < bcpLength; ++i) {
            this.baseColumnPositions[i] = fh.getInt("bcp" + i);
            this.isAscending[i] = fh.getBoolean("isAsc" + i);
        }
        this.numberOfOrderedColumns = fh.getInt("orderedColumns");
        this.indexType = (String)fh.get("indexType");
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        FormatableHashtable fh = new FormatableHashtable();
        fh.putBoolean("isUnique", this.isUnique);
        fh.putInt("keyLength", this.baseColumnPositions.length);
        for (int i = 0; i < this.baseColumnPositions.length; ++i) {
            fh.putInt("bcp" + i, this.baseColumnPositions[i]);
            fh.putBoolean("isAsc" + i, this.isAscending[i]);
        }
        fh.putInt("orderedColumns", this.numberOfOrderedColumns);
        fh.put("indexType", this.indexType);
        out.writeObject(fh);
    }

    public int getTypeFormatId() {
        return 387;
    }

    public boolean equals(Object other) {
        boolean retval = false;
        if (other instanceof IndexDescriptorImpl) {
            IndexDescriptorImpl id = (IndexDescriptorImpl)other;
            if (id.isUnique == this.isUnique && id.baseColumnPositions.length == this.baseColumnPositions.length && id.numberOfOrderedColumns == this.numberOfOrderedColumns && id.indexType.equals(this.indexType)) {
                retval = true;
                for (int i = 0; i < this.baseColumnPositions.length; ++i) {
                    if (id.baseColumnPositions[i] == this.baseColumnPositions[i] && id.isAscending[i] == this.isAscending[i]) continue;
                    retval = false;
                    break;
                }
            }
        }
        return retval;
    }

    public int hashCode() {
        int retval = this.isUnique ? 1 : 2;
        retval *= this.numberOfOrderedColumns;
        for (int i = 0; i < this.baseColumnPositions.length; ++i) {
            retval *= this.baseColumnPositions[i];
        }
        return retval *= this.indexType.hashCode();
    }
}

