/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.types.DataValueDescriptor;

public class DefaultInfoImpl
implements DefaultInfo,
Formatable {
    private DataValueDescriptor defaultValue;
    private String defaultText;
    private int type;
    private static final int BITS_MASK_IS_DEFAULTVALUE_AUTOINC = 1;

    public DefaultInfoImpl() {
    }

    public DefaultInfoImpl(boolean isDefaultValueAutoinc, String defaultText, DataValueDescriptor defaultValue) {
        this.type = DefaultInfoImpl.calcType(isDefaultValueAutoinc);
        this.defaultText = defaultText;
        this.defaultValue = defaultValue;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public String toString() {
        if (this.isDefaultValueAutoinc()) {
            return "GENERATED_BY_DEFAULT";
        }
        return this.defaultText;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.defaultText = (String)in.readObject();
        this.defaultValue = (DataValueDescriptor)in.readObject();
        this.type = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.defaultText);
        out.writeObject(this.defaultValue);
        out.writeInt(this.type);
    }

    public int getTypeFormatId() {
        return 326;
    }

    public DataValueDescriptor getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(DataValueDescriptor defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isDefaultValueAutoinc() {
        return (this.type & 1) != 0;
    }

    private static int calcType(boolean isDefaultValueAutoinc) {
        int value = 0;
        if (isDefaultValueAutoinc) {
            value |= 1;
        }
        return value;
    }
}

