/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.sanity.SanityManager;

public class BaseTypeIdImpl
implements Formatable {
    String SQLTypeName;
    int JDBCTypeId;
    int formatId;
    int wrapperTypeFormatId;

    public BaseTypeIdImpl() {
    }

    public BaseTypeIdImpl(int formatId) {
        this.formatId = formatId;
        this.setTypeIdSpecificInstanceVariables();
    }

    protected BaseTypeIdImpl(String SQLTypeName) {
        this.SQLTypeName = SQLTypeName;
    }

    public String getSQLTypeName() {
        return this.SQLTypeName;
    }

    public int getJDBCTypeId() {
        return this.JDBCTypeId;
    }

    public String toParsableString(TypeDescriptor td) {
        String retval = this.getSQLTypeName();
        switch (this.formatId) {
            case 28: 
            case 30: {
                int rparen = retval.indexOf(41);
                String lead = retval.substring(0, rparen);
                retval = lead + td.getMaximumWidth() + retval.substring(rparen);
                break;
            }
            case 17: 
            case 25: 
            case 366: 
            case 367: 
            case 442: 
            case 446: 
            case 449: {
                retval = retval + "(" + td.getMaximumWidth() + ")";
                break;
            }
            case 198: {
                retval = retval + "(" + td.getPrecision() + "," + td.getScale() + ")";
            }
        }
        return retval;
    }

    public boolean userType() {
        return false;
    }

    public String toString() {
        return MessageService.getTextMessage("44X00.U") + ": " + this.SQLTypeName;
    }

    public boolean equals(Object that) {
        if (that instanceof BaseTypeIdImpl) {
            return this.SQLTypeName.equals(((BaseTypeIdImpl)that).getSQLTypeName());
        }
        return false;
    }

    public int hashCode() {
        return this.SQLTypeName.hashCode();
    }

    public int wrapperTypeFormatId() {
        return this.wrapperTypeFormatId;
    }

    public int getTypeFormatId() {
        return this.formatId;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.SQLTypeName = in.readUTF();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.SQLTypeName);
    }

    private void setTypeIdSpecificInstanceVariables() {
        switch (this.formatId) {
            case 16: {
                this.SQLTypeName = "BOOLEAN";
                this.JDBCTypeId = JVMInfo.JAVA_SQL_TYPES_BOOLEAN;
                this.wrapperTypeFormatId = 4;
                break;
            }
            case 19: {
                this.SQLTypeName = "INTEGER";
                this.JDBCTypeId = 4;
                this.wrapperTypeFormatId = 7;
                break;
            }
            case 22: {
                this.SQLTypeName = "SMALLINT";
                this.JDBCTypeId = 5;
                this.wrapperTypeFormatId = 10;
                break;
            }
            case 196: {
                this.SQLTypeName = "TINYINT";
                this.JDBCTypeId = -6;
                this.wrapperTypeFormatId = 195;
                break;
            }
            case 23: {
                this.SQLTypeName = "BIGINT";
                this.JDBCTypeId = -5;
                this.wrapperTypeFormatId = 11;
                break;
            }
            case 198: {
                this.SQLTypeName = "DECIMAL";
                this.JDBCTypeId = 3;
                this.wrapperTypeFormatId = 197;
                break;
            }
            case 18: {
                this.SQLTypeName = "DOUBLE";
                this.JDBCTypeId = 8;
                this.wrapperTypeFormatId = 6;
                break;
            }
            case 20: {
                this.SQLTypeName = "REAL";
                this.JDBCTypeId = 7;
                this.wrapperTypeFormatId = 8;
                break;
            }
            case 21: {
                this.SQLTypeName = "REF";
                this.JDBCTypeId = 1111;
                this.wrapperTypeFormatId = 9;
                break;
            }
            case 17: {
                this.SQLTypeName = "CHAR";
                this.JDBCTypeId = 1;
                this.wrapperTypeFormatId = 5;
                break;
            }
            case 25: {
                this.SQLTypeName = "VARCHAR";
                this.JDBCTypeId = 12;
                this.wrapperTypeFormatId = 13;
                break;
            }
            case 231: {
                this.SQLTypeName = "LONG VARCHAR";
                this.JDBCTypeId = -1;
                this.wrapperTypeFormatId = 230;
                break;
            }
            case 446: {
                this.SQLTypeName = "CLOB";
                this.JDBCTypeId = 2005;
                this.wrapperTypeFormatId = 444;
                break;
            }
            case 366: {
                this.SQLTypeName = "NATIONAL CHAR";
                this.JDBCTypeId = 1;
                this.wrapperTypeFormatId = 370;
                break;
            }
            case 367: {
                this.SQLTypeName = "NATIONAL CHAR VARYING";
                this.JDBCTypeId = 12;
                this.wrapperTypeFormatId = 369;
                break;
            }
            case 368: {
                this.SQLTypeName = "LONG NVARCHAR";
                this.JDBCTypeId = -1;
                this.wrapperTypeFormatId = 362;
                break;
            }
            case 449: {
                this.SQLTypeName = "NCLOB";
                this.JDBCTypeId = 2005;
                this.wrapperTypeFormatId = 448;
                break;
            }
            case 28: {
                this.SQLTypeName = "CHAR () FOR BIT DATA";
                this.JDBCTypeId = -2;
                this.wrapperTypeFormatId = 27;
                break;
            }
            case 30: {
                this.SQLTypeName = "VARCHAR () FOR BIT DATA";
                this.JDBCTypeId = -3;
                this.wrapperTypeFormatId = 29;
                break;
            }
            case 233: {
                this.SQLTypeName = "LONG VARCHAR FOR BIT DATA";
                this.JDBCTypeId = -4;
                this.wrapperTypeFormatId = 232;
                break;
            }
            case 442: {
                this.SQLTypeName = "BLOB";
                this.JDBCTypeId = 2004;
                this.wrapperTypeFormatId = 440;
                break;
            }
            case 32: {
                this.SQLTypeName = "DATE";
                this.JDBCTypeId = 91;
                this.wrapperTypeFormatId = 40;
                break;
            }
            case 33: {
                this.SQLTypeName = "TIME";
                this.JDBCTypeId = 92;
                this.wrapperTypeFormatId = 35;
                break;
            }
            case 34: {
                this.SQLTypeName = "TIMESTAMP";
                this.JDBCTypeId = 93;
                this.wrapperTypeFormatId = 36;
                break;
            }
            case 457: {
                this.SQLTypeName = "XML";
                this.JDBCTypeId = 456;
                this.wrapperTypeFormatId = 456;
                break;
            }
            default: {
                SanityManager.THROWASSERT("Unexpected formatId " + this.formatId);
            }
        }
    }
}

