/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.catalog.AliasInfo;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.vti.VTITemplate;

public class GetProcedureColumns
extends VTITemplate {
    private boolean isFunction;
    private boolean isProcedure;
    private RoutineAliasInfo procedure;
    private int paramCursor;
    private short method_count;
    private short param_number;
    private TypeDescriptor sqlType;
    private String columnName;
    private short columnType;
    private final short nullable;
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("COLUMN_NAME", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("COLUMN_TYPE", 5, false), EmbedResultSetMetaData.getResultColumnDescriptor("DATA_TYPE", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("TYPE_NAME", 12, false, 22), EmbedResultSetMetaData.getResultColumnDescriptor("PRECISION", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("LENGTH", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("SCALE", 5, false), EmbedResultSetMetaData.getResultColumnDescriptor("RADIX", 5, false), EmbedResultSetMetaData.getResultColumnDescriptor("NULLABLE", 5, false), EmbedResultSetMetaData.getResultColumnDescriptor("REMARKS", 12, true, 22), EmbedResultSetMetaData.getResultColumnDescriptor("METHOD_ID", 5, false), EmbedResultSetMetaData.getResultColumnDescriptor("PARAMETER_ID", 5, false)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    private int translate(int val) {
        if (!this.isFunction) {
            return val;
        }
        switch (val) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
        }
        return 0;
    }

    public ResultSetMetaData getMetaData() {
        return metadata;
    }

    public GetProcedureColumns(AliasInfo aliasInfo, String aliasType) throws SQLException {
        if (aliasInfo != null) {
            this.isProcedure = aliasType.equals("P");
            this.isFunction = aliasType.equals("F");
            this.procedure = (RoutineAliasInfo)aliasInfo;
            this.method_count = (short)this.procedure.getParameterCount();
        }
        if (aliasType == null) {
            this.nullable = 0;
            return;
        }
        if (this.isFunction) {
            this.nullable = 1;
            this.sqlType = this.procedure.getReturnType();
            this.columnName = "";
            this.columnType = (short)4;
            this.paramCursor = -2;
            return;
        }
        this.nullable = 1;
        this.paramCursor = -1;
    }

    public boolean next() throws SQLException {
        if (++this.paramCursor >= this.procedure.getParameterCount()) {
            return false;
        }
        if (this.paramCursor > -1) {
            this.sqlType = this.procedure.getParameterTypes()[this.paramCursor];
            this.columnName = this.procedure.getParameterNames()[this.paramCursor];
            this.columnType = (short)this.translate(this.procedure.getParameterModes()[this.paramCursor]);
        }
        this.param_number = (short)this.paramCursor;
        return true;
    }

    public String getString(int column) throws SQLException {
        switch (column) {
            case 1: {
                return this.columnName;
            }
            case 4: {
                return this.sqlType.getTypeName();
            }
            case 10: {
                return null;
            }
        }
        return super.getString(column);
    }

    public int getInt(int column) throws SQLException {
        switch (column) {
            case 3: {
                if (this.sqlType != null) {
                    return this.sqlType.getJDBCTypeId();
                }
                return 2000;
            }
            case 5: {
                if (this.sqlType != null) {
                    int type = this.sqlType.getJDBCTypeId();
                    if (DataTypeDescriptor.isNumericType(type)) {
                        return this.sqlType.getPrecision();
                    }
                    if (type == 91 || type == 92 || type == 93) {
                        return DataTypeUtilities.getColumnDisplaySize(type, -1);
                    }
                    return this.sqlType.getMaximumWidth();
                }
                return 0;
            }
            case 6: {
                if (this.sqlType != null) {
                    return this.sqlType.getMaximumWidthInBytes();
                }
                return 0;
            }
        }
        return super.getInt(column);
    }

    public short getShort(int column) throws SQLException {
        switch (column) {
            case 2: {
                return this.columnType;
            }
            case 7: {
                if (this.sqlType != null) {
                    return (short)this.sqlType.getScale();
                }
                return 0;
            }
            case 8: {
                if (this.sqlType != null) {
                    int sqlTypeID = this.sqlType.getJDBCTypeId();
                    if (sqlTypeID == 7 || sqlTypeID == 6 || sqlTypeID == 8) {
                        return 2;
                    }
                    return 10;
                }
                return 0;
            }
            case 9: {
                return this.nullable;
            }
            case 11: {
                return this.method_count;
            }
            case 12: {
                return this.param_number;
            }
        }
        return super.getShort(column);
    }

    public void close() {
    }
}

